<?php
   $ziptech_redux_demo = get_option('redux_demo');
   get_header(); 
?>
<?php 
    while (have_posts()): the_post();
?>
<?php $image_single = get_post_meta(get_the_ID(),'_cmb_image_single', true); ?>
<?php if(isset($ziptech_redux_demo['blog_single_image']['url']) && $ziptech_redux_demo['blog_single_image']['url'] != ''){?> 
<section class="page-title-section" style="background-image: url(<?php echo esc_attr($ziptech_redux_demo['blog_single_image']);?>);">
<?php }else{?>
<section class="page-title-section">
<?php } ?>
  <div class="container">
    <div class="row">
      <div class="col-xl-12">
        <div class="breadcrumb-area">
          <h2 class="page-title"><?php if(isset($ziptech_redux_demo['single_title'])){?>
            <?php echo esc_attr($ziptech_redux_demo['single_title']);?>
            <?php }else{?>
            <?php echo esc_html__( 'News Details', 'ziptech' ); } ?></h2>
          <ul class="breadcrumbs-link">
            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($ziptech_redux_demo['home'])){?>
                            <?php echo esc_attr($ziptech_redux_demo['home']);?>
                            <?php }else{?>
                            <?php echo esc_html__( 'Home', 'ziptech' ); } ?></a></li>
            <li class="active"><?php if(isset($ziptech_redux_demo['single_title'])){?>
            <?php echo esc_attr($ziptech_redux_demo['single_title']);?>
            <?php }else{?>
            <?php echo esc_html__( 'News Details', 'ziptech' ); } ?></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Page Title End -->
<!-- Service Details Section Start -->
<section class="blog-single-news pdt-110 pdb-90">
  <div class="container">
    <div class="row">
      <div class="col-xl-8 col-lg-7">
        <div class="single-news-details news-wrapper mrb-20">
          <div class="single-news-content">
            <?php if (wp_get_attachment_url($image_single) !='')  { ?>
            <div class="news-thumb">
              <img src="<?php echo wp_get_attachment_url($image_single);?>" class="img-full" alt="blog" />
            </div>
            <?php } ?>
            <div class="news-description mrb-10">
              <h3 class="the-title"><?php the_title(); ?></h3>
              <div class="news-bottom-part">
                <div class="post-author mrr-30 mrb-sm-15">
                  <div class="author-img">
                    <a>
                      <img src="<?php echo get_template_directory_uri();?>/images/testimonials/testimonial-img3.jpg" class="rounded-circle" alt="#" />
                    </a>
                  </div>
                  <span><?php the_author();?></span>
                </div>
                <div class="post-link mrr-30 mrb-sm-15">
                  <a><span class="entry-date"><i class="far fa-calendar-alt mrr-10 text-primary-color"></i><?php the_time(get_option( 'date_format' ));?></span>
                  </a>
                </div>
                <div class="post-link comments">
                  <i class="far fa-comments mrr-10 text-primary-color"></i>
                  <a><?php comments_number( esc_html__('0 Comments', 'ziptech'), esc_html__('1 Comment', 'ziptech'), esc_html__('% Comments', 'ziptech') ); ?></a>
                </div>
              </div>
            </div>
            <div class="entry-content">
                <?php the_content(); ?>
                <?php wp_link_pages( array(
                    'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'ziptech' ),
                    'after'       => '</div>',
                    'link_before' => '<p class="page-number">',
                    'link_after'  => '</p>',
                ) ); ?>
            </div>
            <div class="single-news-tag-social-area clearfix">
              <div class="single-news-tags f-left f-left-none mrb-lg-30">
                <h5 class="mrb-15"><?php if(isset($ziptech_redux_demo['tags'])){?>
            <?php echo esc_attr($ziptech_redux_demo['tags']);?>
            <?php }else{?>
            <?php echo esc_html__( 'Related Tags:', 'ziptech' ); } ?></h5>
                <ul class="list">
                  <li><?php echo get_the_tag_list();?></li>
                </ul>
              </div>
              <div class="single-news-share text-start text-xl-end">
                <h5 class="mrb-15"><?php if(isset($ziptech_redux_demo['share'])){?>
            <?php echo esc_attr($ziptech_redux_demo['share']);?>
            <?php }else{?>
            <?php echo esc_html__( 'Social Share:', 'ziptech' ); } ?></h5>
                <ul class="social-icons">
                  <li>
                    <a href="https://www.facebook.com/" target="_blank"><i class="fab fa-facebook-f"></i></a>
                  </li>
                  <li>
                    <a href="https://twitter.com/" target="_blank"><i class="fab fa-twitter"></i></a>
                  </li>
                  <li>
                    <a href="https://www.linkedin.com/" target="_blank"><i class="fab fa-linkedin"></i></a>
                  </li>
                  <li>
                    <a href="https://www.instagram.com/" target="_blank"><i class="fab fa-instagram"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="comments-area">
              <?php comments_template();?>
            </div>
          </div>
        </div>
        </div>
        <div class="col-xl-4 col-lg-5 sidebar-right">
            <aside class="news-sidebar-widget">
                <?php get_sidebar();?>
            </aside>
        </div>
    </div>
  </div>
</section>
<?php endwhile; ?>
<?php
    get_footer();
?>

