<?php
   $ziptech_redux_demo = get_option('redux_demo');
   get_header(); 
?>
<?php 
    while (have_posts()): the_post();
?>
<section class="page-title-section">
  <div class="container">
    <div class="row">
      <div class="col-xl-12">
        <div class="breadcrumb-area">
          <h2 class="page-title"><?php the_title(); ?></h2>
          <ul class="breadcrumbs-link">
            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($ziptech_redux_demo['home'])){?>
                            <?php echo esc_attr($ziptech_redux_demo['home']);?>
                            <?php }else{?>
                            <?php echo esc_html__( 'Home', 'ziptech' ); } ?></a></li>
            <li class="active"><?php the_title(); ?></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Page Title End -->
<!-- Team Details Section Start -->
<section class="team-details-page bg-no-repeat bg-cover bg-pos-cb pdt-110 pdb-80" data-background="<?php echo get_template_directory_uri();?>/images/bg/abs-bg8.png">
  <div class="container">
    <div class="row mrb-40">
      <div class="col-xl-6 col-lg-12 col-md-12">
        <div class="single-team-img mrb-lg-40">
          <img class="img-full" src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="" />
        </div>
      </div>
      <div class="col-xl-6 col-lg-12 col-md-12">
        <div class="team-member-info pdl-30 pdl-lg-0">
          <h3 class="team-title mrt-0 mrb-5"><?php the_title(); ?></h3>
          <?php 
              $cates = get_the_terms(get_the_ID(),'Type3');
              $cate_name = '';
              $cate_slug = '';
              foreach((array)$cates as $cate){
              if(count($cates)>0){
                  $cate_name .= $cate->name.' ';
                  $cate_slug .= $cate->slug.' ';
              }
          ?>
          <h6 class="designation text-primary-color mrb-20"><?php echo esc_attr($cate_name);?></h6>
          <?php } ?>
          <?php the_content(); ?>
        <?php wp_link_pages( array(
            'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'ziptech' ),
            'after'       => '</div>',
            'link_before' => '<p class="page-number">',
            'link_after'  => '</p>',
        ) ); ?>
          
  </div>
</section>
<?php endwhile; ?>
<?php
    get_footer();
?>

