<?php
   $ziptech_redux_demo = get_option('redux_demo');
   get_header(); 
?>
<?php 
    while (have_posts()): the_post();
?>
<?php $image_home = get_post_meta(get_the_ID(),'_cmb_image_home', true); ?>
<section class="page-title-section">
      <div class="container">
        <div class="row">
          <div class="col-xl-12">
            <div class="breadcrumb-area">
              <h2 class="page-title"><?php the_title(); ?></h2>
              <ul class="breadcrumbs-link">
                <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($ziptech_redux_demo['home'])){?>
                            <?php echo esc_attr($ziptech_redux_demo['home']);?>
                            <?php }else{?>
                            <?php echo esc_html__( 'Home', 'ziptech' ); } ?></a></li>
                <li class="active"><?php the_title(); ?></li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Page Title End -->
    <!-- Project Details Section Start -->
    <section class="project-details-page pdt-110 pdb-0">
      <div class="container">
        
        <?php the_content(); ?>
        <?php wp_link_pages( array(
            'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'ziptech' ),
            'after'       => '</div>',
            'link_before' => '<p class="page-number">',
            'link_after'  => '</p>',
        ) ); ?>

      </div>
    </section>
<?php endwhile; ?>
    <section class="project-details-page pdt-0 pdb-80">
      <div class="container">
        <div class="row mrt-40">
          <div class="col-xl-12">
            <h3 class="mrb-30">Related Projects</h3>
            <div class="row">
              <?php $args = array(    
                'paged' => $paged,
                'post_type' => 'projects',
                'posts_per_page' => 4,
                );
                $wp_query = new WP_Query($args);
                while (have_posts()): the_post();
                $cates = get_the_terms(get_the_ID(),'Type2');
                    $cate_name = '';
                    $cate_slug = '';
                foreach((array)$cates as $cate){
                    if(count($cates)>0){
                        $cate_name .= $cate->name.' ';
                        $cate_slug .= $cate->slug.' ';
                    }
                }
                ?>
                <?php $image_home = get_post_meta(get_the_ID(),'_cmb_image_home', true); ?>
                <?php $icon = get_post_meta(get_the_ID(),'_cmb_icon', true); ?>
              <div class="col-md-6 col-lg-6 col-xl-3 service-wrapper">
                <div class="project-item-style1">
                  <span class="<?php echo esc_attr($icon);?>"></span>
                  <div class="project-item-thumb">
                    <a class="project-item-link-image" href="<?php the_permalink();?>">
                      <img class="img-full" src="<?php echo wp_get_attachment_url($image_home);?>" alt="" />
                    </a>
                  </div>
                  <div class="project-item-details">
                    <div class="project-item-details-inner">
                      <h6 class="project-item-category"><a href="<?php the_permalink();?>"><?php echo esc_attr($cate_name);?></a></h6>
                      <h4 class="title"><?php the_title(); ?></h4>
                      <div class="project-item-link-icon">
                        <a href="<?php the_permalink();?>"><i class="base-icon-next"></i></a>
                      </div>
                    </div>
                  </div>
                  <div class="project-item-details-hover">
                    <div class="project-item-details-inner">
                      <h4 class="title"><?php the_title(); ?></h4>
                      <div class="desc"><?php if(isset($ziptech_redux_demo['projects_excerpt'])){?>
                            <?php echo esc_attr(ziptech_excerpt4($ziptech_redux_demo['projects_excerpt'])); ?>
                            <?php }else{?>
                            <?php echo esc_attr(ziptech_excerpt4(10)); } ?></div>
                      <div class="project-item-link-icon">
                        <a href="<?php the_permalink();?>"><i class="base-icon-next"></i></a>
                      </div>
                    </div>
                  </div>
                  <a class="bg-overlay" href="<?php the_permalink();?>"></a>
                </div>
              </div>
              <?php endwhile; ?>
            </div>
          </div>
        </div>
      </div>
    </section>

<?php
    get_footer();
?>

