<?php
/*
 * Template Name: Blog Grid
 * Description: A Page Template with a Page Builder design.
 */
$inc_redux_demo = get_option('redux_demo');
get_header(); ?>
<section class="page-title-section">
  <div class="container">
    <div class="row">
      <div class="col-xl-12">
        <div class="breadcrumb-area">
          <h2 class="page-title">News</h2>
          <ul class="breadcrumbs-link">
            <li><a href="<?php echo esc_url(home_url('/')); ?>">Home</a></li>
            <li class="active">News</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Page Title End -->
<!-- News Section Start -->
<section class="pdt-105 pdb-80">
  <div class="section-content">
    <div class="container">
      <div class="row justify-content-center">
        <?php $args = array(    
        'paged' => $paged,
        'post_type' => 'post',
        'posts_per_page' => 6,
        );
        $wp_query = new WP_Query($args);
        while (have_posts()): the_post();
        $cates = get_the_terms(get_the_ID(),'category');
            $cate_name = '';
            $cate_slug = '';
        foreach((array)$cates as $cate){
            if(count($cates)>0){
                $cate_name .= $cate->name.' ';
                $cate_slug .= $cate->slug.' ';
            }
        }
        ?>
        <div class="col-md-6 col-lg-6 col-xl-4">
          <div class="news-wrapper-style1 mrb-30">
            <div class="news-thumb">
              <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" class="img-full" alt="blog" />
              <div class="news-top-meta">
                <span class="entry-category"><?php echo esc_attr($cate_name);?></span>
              </div>
            </div>
            <div class="news-description">
              <h4 class="the-title">
                <a href="<?php the_permalink();?>"><?php the_title(); ?></a>
              </h4>
              <div class="news-bottom-part">
                <div class="post-author">
                  <div class="author-img">
                    <a href="<?php the_permalink();?>">
                      <img src="<?php echo get_template_directory_uri();?>/images/testimonials/testimonial-img1.jpg" class="rounded-circle" alt="#" />
                    </a>
                  </div>
                  <span><a href="<?php the_permalink();?>"><?php the_author();?></a></span>
                </div>
                <div class="post-link">
                  <span class="entry-date"><i class="far fa-calendar-alt mrr-10 text-gradient-color"></i><?php the_time(get_option( 'date_format' ));?></span>
                </div>
              </div>
            </div>
          </div>
        </div>
        <?php endwhile; ?>
      </div>
    </div>
  </div>
</section>
<?php
get_footer();
?>