<?php
/*
 * Template Name: Blog Grid Sidebar Left 
 * Description: A Page Template with a Page Builder design.
 */
$ziptech_redux_demo = get_option('redux_demo');
get_header(); ?>
<?php if(isset($ziptech_redux_demo['blog_image']['url']) && $ziptech_redux_demo['blog_image']['url'] != ''){?> 
<section class="page-title-section" style="background-image: url(<?php echo esc_attr($ziptech_redux_demo['blog_image']);?>);">
<?php }else{?>
<section class="page-title-section">
<?php } ?>  <div class="container">
    <div class="row">
      <div class="col-xl-12">
        <div class="breadcrumb-area">
          <h2 class="page-title"><?php if(isset($ziptech_redux_demo['blog_title'])){?>
            <?php echo esc_attr($ziptech_redux_demo['blog_title']);?>
            <?php }else{?>
            <?php echo esc_html__( 'News Left Sidebar', 'ziptech' ); } ?></h2>
          <ul class="breadcrumbs-link">
            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($ziptech_redux_demo['home'])){?>
                            <?php echo esc_attr($ziptech_redux_demo['home']);?>
                            <?php }else{?>
                            <?php echo esc_html__( 'Home', 'ziptech' ); } ?></a></li>
            <li class="active"><?php if(isset($ziptech_redux_demo['blog_title'])){?>
            <?php echo esc_attr($ziptech_redux_demo['blog_title']);?>
            <?php }else{?>
            <?php echo esc_html__( 'News Left Sidebar', 'ziptech' ); } ?></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Page Title End -->
<!-- News Left Sidebar Section Start -->
<div class="news-left-sidebar-page pdt-110 pdb-70">
  <div class="container">
    <div class="row">
      <div class="col-xl-4 col-lg-5 sidebar-right">
        <aside class="news-sidebar-widget">
          <?php get_sidebar();?> 
        </aside>
      </div>
      <div class="col-xl-8 col-lg-7">
        <div class="row justify-content-center">
        	<?php $args = array(    
	        'paged' => $paged,
	        'post_type' => 'post',
	        'posts_per_page' => 6,
	        );
	        $wp_query = new WP_Query($args);
	        while (have_posts()): the_post();
	        $cates = get_the_terms(get_the_ID(),'category');
	            $cate_name = '';
	            $cate_slug = '';
	        foreach((array)$cates as $cate){
	            if(count($cates)>0){
	                $cate_name .= $cate->name.' ';
	                $cate_slug .= $cate->slug.' ';
	            }
	        }
	        ?>
          <div class="col-md-6 col-lg-6 col-xl-6">
            <div class="news-wrapper-style1 mrb-30">
              <div class="news-thumb">
                <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" class="img-full" alt="blog" />
                <div class="news-top-meta">
                  <span class="entry-category"><?php echo esc_attr($cate_name);?></span>
                </div>
              </div>
              <div class="news-description">
                <h4 class="the-title">
                  <a href="<?php the_permalink();?>"><?php the_title(); ?></a>
                </h4>
                <div class="news-bottom-part">
                  <div class="post-author">
                    <div class="author-img">
                      <a href="<?php the_permalink();?>">
                        <img src="<?php echo get_template_directory_uri();?>/images/testimonials/testimonial-img1.jpg" class="rounded-circle" alt="#" />
                      </a>
                    </div>
                    <span><a href="<?php the_permalink();?>"><?php the_author();?></a></span>
                  </div>
                  <div class="post-link">
                    <span class="entry-date"><i class="far fa-calendar-alt mrr-10 text-gradient-color"></i><?php the_time(get_option( 'date_format' ));?></span>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <?php endwhile; ?>
        </div>
        <div class="row">
          <div class="col-xl-12">
            <nav class="pagination-nav pdt-30">
              <?php 
	            $pagination = array(
	            'base'      => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
	            'format'    => '',
	            'prev_text' => wp_specialchars_decode(esc_html__( '<i class="fa fa-angle-left"></i>', 'ziptech' ),ENT_QUOTES),
	            'next_text' => wp_specialchars_decode(esc_html__( '<i class="fa fa-angle-right"></i>', 'ziptech' ),ENT_QUOTES),
	            'type'      => 'list',
	            'end_size'    => 3,
	            'mid_size'    => 3
	            );
	            if(paginate_links( $pagination ) != ''){
	                $return =  paginate_links( $pagination );
	                echo str_replace( "<ul class='page-numbers'>", '<ul class="pagination-list">', $return );
	            }
	            ?>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
    <?php
get_footer();
?>