<!doctype html>
<html <?php language_attributes(); ?>>
<?php $ziptech_redux_demo = get_option('redux_demo'); ?>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>
        <?php if(isset($ziptech_redux_demo['favicon']['url'])){?>
        <link rel="shortcut icon" href="<?php echo esc_url($ziptech_redux_demo['favicon']['url']); ?>">
        <?php }?>
    <?php }?>
    <?php wp_head(); ?> 
</head>
<body <?php body_class(); ?>>
<!--[if lt IE 8]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->
<!-- < NAVIGATION WITH BACKGROUND COLOR NAVBAR >............................................ -->
<!-- removed navbar-toggleable-md because responsive issues. Find out why ..... -->
<!-- start page-wrapper -->
<!-- PRELOADER -->
<section>
      <div id="preloader">
        <div id="ctn-preloader" class="ctn-preloader">
          <div class="animation-preloader">
            <div class="spinner"></div>
            <div class="txt-loading">
              <span data-text-preloader="L" class="letters-loading">L</span>
              <span data-text-preloader="O" class="letters-loading">O</span>
              <span data-text-preloader="G" class="letters-loading">G</span>
              <span data-text-preloader="I" class="letters-loading">I</span>
              <span data-text-preloader="S" class="letters-loading">S</span>
              <span data-text-preloader="T" class="letters-loading">T</span>
              <span data-text-preloader="A" class="letters-loading">A</span>
            </div>
          </div>
          <div class="loader-section section-left"></div>
          <div class="loader-section section-right"></div>
        </div>
      </div>
    </section>
    <!-- Preloader End -->
    <!-- Header Area Start -->
    <header class="header-style-03">
      <div class="header-topbar">
        <div class="topbar-wrapper">
          <ul class="topbar-info">
            <?php if($ziptech_redux_demo['mail'] != ''){?>
            <li>
              <i class="base-icon-email1"></i>
              <a href="mailto:<?php echo esc_attr($ziptech_redux_demo['mail']); ?>"><?php echo esc_attr($ziptech_redux_demo['mail']); ?></a>
            </li>
            <?php } ?>
            <?php if($ziptech_redux_demo['address'] != ''){?>
            <li>
              <i class="base-icon-pin2"></i>
              <?php echo esc_attr($ziptech_redux_demo['address']); ?>
            </li>
            <?php } ?>
          </ul>
          <ul class="topbar-social">
            <?php if($ziptech_redux_demo['twitter'] != ''){?>
            <li>
              <a href="<?php echo esc_attr($ziptech_redux_demo['twitter']); ?>"><i class="fab fa-twitter"></i></a>
            </li>
            <?php } ?>
            <?php if($ziptech_redux_demo['facebook'] != ''){?>
            <li>
              <a href="<?php echo esc_attr($ziptech_redux_demo['facebook']); ?>"><i class="fab fa-facebook"></i></a>
            </li>
            <?php } ?>
            <?php if($ziptech_redux_demo['pinterest'] != ''){?>
            <li>
              <a href="<?php echo esc_attr($ziptech_redux_demo['pinterest']); ?>"><i class="fab fa-pinterest-p"></i></a>
            </li>
            <?php } ?>
            <?php if($ziptech_redux_demo['instagram'] != ''){?>
            <li>
              <a href="<?php echo esc_attr($ziptech_redux_demo['instagram']); ?>"><i class="fab fa-instagram"></i></a>
            </li>
            <?php } ?>
          </ul>
        </div>
      </div>
      <nav class="main-menu sticky-header">
        <div class="main-menu-wrapper">
          <?php if(isset($ziptech_redux_demo['logo']['url']) && $ziptech_redux_demo['logo']['url'] != ''){?> 
          <div class="main-menu-logo">
            <a href="<?php echo esc_url(home_url('/')); ?>">
              <img src="<?php echo esc_url($ziptech_redux_demo['logo']['url']);?>" width="165" height="72" alt="logo" />
            </a>
          </div>
          <?php }else{?>
          <div class="main-menu-logo">
            <a href="<?php echo esc_url(home_url('/')); ?>">
              <img src="<?php echo get_template_directory_uri();?>/images/logo-dark.png" width="165" height="72" alt="logo" />
            </a>
          </div>
          <?php } ?>
            <?php 
            wp_nav_menu( 
                array( 
                    'theme_location' => 'primary',
                    'container' => '',
                    'menu_class' => '', 
                    'menu_id' => '',
                    'menu'            => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'echo'            => true,
                     'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                     'walker'            => new ziptech_wp_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul class=" main-nav-menu %2$s" >%3$s</ul>',
                    'depth'           => 0,        
                )
            ); ?>
          <div class="main-menu-right">
            <a href="#" class="mobile-nav-toggler">
              <span></span>
              <span></span>
              <span></span>
            </a>
            <a href="#" class="search-toggler">
              <i class="base-icon-search-1"></i>
            </a>
            <div class="header-contact-info">
              <div class="header-contact-info-icon">
                <i class="base-icon-011-phone-1"></i>
              </div>
              <?php if($ziptech_redux_demo['phone_number'] != ''){?>
              <div class="header-contact-info-text">
                <p class="call-text"><?php echo esc_attr($ziptech_redux_demo['phone']); ?></p>
                <h5 class="phone-no"><a href="tel:<?php echo esc_attr($ziptech_redux_demo['phone_number']); ?>"><?php echo esc_attr($ziptech_redux_demo['phone_number']); ?></a></h5>
              </div>
              <?php } ?>
            </div>
          </div>
        </div>
      </nav>
    </header>