<!doctype html>
<html <?php language_attributes(); ?>>
<?php $ziptech_redux_demo = get_option('redux_demo'); ?>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>
        <?php if(isset($ziptech_redux_demo['favicon']['url'])){?>
        <link rel="shortcut icon" href="<?php echo esc_url($ziptech_redux_demo['favicon']['url']); ?>">
        <?php }?>
    <?php }?>
    <script id="www-widgetapi-script" src="https://s.ytimg.com/yts/jsbin/www-widgetapi-vflS50iB-/www-widgetapi.js" async=""></script>
    <script src="https://www.youtube.com/player_api"></script>
    <?php wp_head(); ?> 
</head>
<body <?php body_class(); ?>>
<!--[if lt IE 8]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->
<!-- < NAVIGATION WITH BACKGROUND COLOR NAVBAR >............................................ -->
<!-- removed navbar-toggleable-md because responsive issues. Find out why ..... -->
<!-- start page-wrapper -->
<!-- PRELOADER -->
<section>
      <div id="preloader">
        <div id="ctn-preloader" class="ctn-preloader">
          <div class="animation-preloader">
            <div class="spinner"></div>
            <div class="txt-loading">
              <span data-text-preloader="Z" class="letters-loading">Z</span>
              <span data-text-preloader="I" class="letters-loading">I</span>
              <span data-text-preloader="P" class="letters-loading">P</span>
              <span data-text-preloader="T" class="letters-loading">T</span>
              <span data-text-preloader="E" class="letters-loading">E</span>
              <span data-text-preloader="C" class="letters-loading">C</span>
              <span data-text-preloader="H" class="letters-loading">H</span>
            </div>
          </div>
          <div class="loader-section section-left"></div>
          <div class="loader-section section-right"></div>
        </div>
      </div>
    </section>
    <!-- Preloader End -->
    <!-- Header Area Start -->
    <header class="header-style-02">
      <nav class="main-menu sticky-header">
        <div class="container">
          <div class="main-menu-inner">
            <?php if(isset($ziptech_redux_demo['logo_light']['url']) && $ziptech_redux_demo['logo_light']['url'] != ''){?> 
            <div class="main-menu-logo">
              <a href="<?php echo esc_url(home_url('/')); ?>">
                <img src="<?php echo esc_url($ziptech_redux_demo['logo_light']['url']);?>" alt="logo" />
              </a>
            </div>
            <?php }else{?>
            <div class="main-menu-logo">
              <a href="<?php echo esc_url(home_url('/')); ?>">
                <img src="<?php echo get_template_directory_uri();?>/images/logo-light.png" alt="logo" />
              </a>
            </div>
            <?php } ?>
            <?php 
              wp_nav_menu( 
                  array( 
                      'theme_location' => 'primary',
                      'container' => '',
                      'menu_class' => '', 
                      'menu_id' => '',
                      'menu'            => '',
                      'container_class' => '',
                      'container_id'    => '',
                      'echo'            => true,
                       'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                       'walker'            => new ziptech_wp_bootstrap_navwalker(),
                      'before'          => '',
                      'after'           => '',
                      'link_before'     => '',
                      'link_after'      => '',
                      'items_wrap'      => '<ul class=" main-nav-menu %2$s" >%3$s</ul>',
                      'depth'           => 0,        
                  )
              ); ?>
            <div class="main-menu-right">
              <a href="#" class="mobile-nav-toggler">
                <span></span>
                <span></span>
                <span></span>
              </a>
              <a href="#" class="search-toggler">
                <i class="base-icon-search-1"></i>
              </a>
              <?php if($ziptech_redux_demo['contact'] != ''){?>
              <div class="header-contact-btn">
                <a href="<?php echo esc_attr($ziptech_redux_demo['link_contact']); ?>" class="theme-btn-2"><?php echo esc_attr($ziptech_redux_demo['contact']); ?></a>
              </div>
              <?php } ?>
            </div>
          </div>
        </div>
      </nav>
    </header>