<?php
$ziptech_redux_demo = get_option('redux_demo');

//Custom fields:
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/framework/widget/recent-post.php';
require_once get_template_directory() . '/framework/class-ocdi-importer.php';
//Theme Set up:
function ziptech_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
  	add_theme_support( 'custom-header' ); 
  	add_theme_support( 'custom-background' );
  	$lang = get_template_directory_uri() . '/languages';
    load_theme_textdomain('Alfzami', $lang);
    remove_filter('the_content', 'wpautop');
    add_theme_support( 'post-thumbnails' );
    // Adds RSS feed links to <head> for posts and comments.
    add_theme_support( 'automatic-feed-links' );
    // Switches default core markup for search form, comment form, and comments
    // to output valid HTML5.
    add_theme_support( 'title-tag' );
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    // This theme uses wp_nav_menu() in one location.
  	register_nav_menus( array(
      'primary' =>  esc_html__( 'Primary Menu: Chosen menu in Blog and Home', 'ziptech' ),
      'primary_rtl' =>  esc_html__( 'Primary RTL Menu: Chosen menu in Home RTL', 'ziptech' ),
      'primary_onepage' =>  esc_html__( 'Primary Onepage Menu: Chosen menu in Home Onepage', 'ziptech' ),
      'menu_service' =>  esc_html__( 'Menu Services: Chosen menu in Menu Services', 'ziptech' ),
  	) );
      // This theme uses its own gallery styles.
}
add_action( 'after_setup_theme', 'ziptech_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;

function ziptech_theme_scripts_styles() {
  	$ziptech_redux_demo = get_option('redux_demo');
  	$protocol = is_ssl() ? 'https' : 'http';
    if (!is_page_template( 'page-templates/home-rtl-layout1.php' ) & !is_page_template( 'page-templates/home-rtl-layout2.php' )& !is_page_template( 'page-templates/home-rtl-layout3.php' )& !is_page_template( 'page-templates/home-rtl-layout4.php' )& !is_page_template( 'page-templates/home-rtl-layout5.php' )& !is_page_template( 'page-templates/home-rtl-layout6.php' )) {
    wp_enqueue_style( 'ziptech-style', get_template_directory_uri().'/css/style.css');
    wp_enqueue_style( 'ziptech-responsive', get_template_directory_uri().'/css/responsive.css');
    }
    if (is_page_template( 'page-templates/home-dark-layout1.php' ) || is_page_template( 'page-templates/home-dark-layout2.php' ) || is_page_template( 'page-templates/home-dark-layout3.php' ) || is_page_template( 'page-templates/home-dark-layout4.php' ) || is_page_template( 'page-templates/home-dark-layout5.php' ) || is_page_template( 'page-templates/home-dark-layout6.php' )  ) {
    wp_enqueue_style( 'ziptech-style-dark', get_template_directory_uri().'/css/style-dark.css');
    }
    if (is_page_template( 'page-templates/home-rtl-layout1.php' ) || is_page_template( 'page-templates/home-rtl-layout2.php' ) || is_page_template( 'page-templates/home-rtl-layout3.php' ) || is_page_template( 'page-templates/home-rtl-layout4.php' ) || is_page_template( 'page-templates/home-rtl-layout5.php' ) || is_page_template( 'page-templates/home-rtl-layout6.php' )  ) {
    wp_enqueue_style( 'bootstrap-rtl', get_template_directory_uri().'/css/bootstrap.rtl.min.css');
    wp_enqueue_style( 'bootstrap-grid-rtl', get_template_directory_uri().'/css/bootstrap-grid.rtl.min.css');
    wp_enqueue_style( 'bootstrap-reboot-rtl', get_template_directory_uri().'/css/bootstrap-reboot.rtl.min.css');
    wp_enqueue_style( 'bootstrap-utilities-rtl', get_template_directory_uri().'/css/bootstrap-utilities.rtl.min.css');
    wp_enqueue_style( 'ziptech-style-rtl', get_template_directory_uri().'/css/style-rtl.css');
    wp_enqueue_style( 'ziptech-style-rtl-modify', get_template_directory_uri().'/css/style-rtl-modify.css');
    wp_enqueue_style( 'ziptech-responsive-rtl', get_template_directory_uri().'/css/responsive-rtl.css');
    }
    wp_enqueue_style( 'ziptech-css', get_stylesheet_uri(), array(), '2023-03-20' );
    if(isset($ziptech_redux_demo['chosen-color']) && $ziptech_redux_demo['chosen-color']==1){
    wp_enqueue_style( 'color', get_template_directory_uri().'/framework/color.php');
    }
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
    wp_enqueue_script( 'comment-reply' );
    //Javascript
    wp_enqueue_script( 'jquery' );
    wp_enqueue_script('jquery-3.6.0', get_template_directory_uri().'/js/jquery-3.6.0.min.js',array(),false,true);
    wp_enqueue_script('jquery-nice-select', get_template_directory_uri().'/js/jquery.nice-select.min.js',array(),false,true);
    wp_enqueue_script('bootstrap', get_template_directory_uri().'/js/bootstrap.min.js',array(),false,true);
    wp_enqueue_script('jquery-appear', get_template_directory_uri().'/js/jquery.appear.min.js',array(),false,true);
    wp_enqueue_script('wow', get_template_directory_uri().'/js/wow.min.js',array(),false,true);
    wp_enqueue_script('owl-carousel', get_template_directory_uri().'/js/owl.carousel.min.js',array(),false,true);
    wp_enqueue_script('jquery-event-move', get_template_directory_uri().'/js/jquery.event.move.js',array(),false,true);
    wp_enqueue_script('jquery-twentytwenty', get_template_directory_uri().'/js/jquery.twentytwenty.js',array(),false,true);
    wp_enqueue_script('tilt-jquery', get_template_directory_uri().'/js/tilt.jquery.min.js',array(),false,true);
    wp_enqueue_script('magnific-popup', get_template_directory_uri().'/js/magnific-popup.min.js',array(),false,true);
    wp_enqueue_script('ziptech-backtotop', get_template_directory_uri().'/js/backtotop.js',array(),false,true);
    wp_enqueue_script('ziptech-trigger', get_template_directory_uri().'/js/trigger.js',array(),false,true);
}
add_action( 'wp_enqueue_scripts', 'ziptech_theme_scripts_styles' );
function move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}
add_filter( 'comment_form_fields', 'move_comment_field_to_bottom');
//Custom Excerpt Function
function ziptech_do_shortcode($content) {
    global $shortcode_tags;
    if (empty($shortcode_tags) || !is_array($shortcode_tags))
        return $content;
    $pattern = get_shortcode_regex();
    return preg_replace_callback( "/$pattern/s", 'do_shortcode_tag', $content );
} 
// Widget Sidebar
function ziptech_widgets_init() {
  	register_sidebar( array(
      'name'          => esc_html__( 'Primary Sidebar', 'ziptech' ),
      'id'            => 'sidebar-1',        
  		'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'ziptech' ),        
  		'before_widget' => '<div class="widget sidebar-widget widget-%2$s" id="%2$s">',        
  		'after_widget'  => '</div>',        
  		'before_title'  => '<h4 class="mrb-20 single-blog-widget-title">',        
  		'after_title'   => '</h4>'
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Services Sidebar', 'ziptech' ),
      'id'            => 'services-1',        
      'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'ziptech' ),        
      'before_widget' => '',        
      'after_widget'  => '',        
      'before_title'  => '',        
      'after_title'   => ''
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer One Widget', 'ziptech' ),
      'id'            => 'footer-area-1',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '',
      'after_widget'  => '',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Two Widget', 'ziptech' ),
      'id'            => 'footer-area-2',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Three Widget', 'ziptech' ),
      'id'            => 'footer-area-3',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Four Widget', 'ziptech' ),
      'id'            => 'footer-area-4',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer One Widget RTL', 'ziptech' ),
      'id'            => 'footer-area-1-rtl',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Two Widget RTL', 'ziptech' ),
      'id'            => 'footer-area-2-rtl',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Three Widget RTL', 'ziptech' ),
      'id'            => 'footer-area-3-rtl',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Four Widget RTL', 'ziptech' ),
      'id'            => 'footer-area-4-rtl',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'ziptech' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
}
add_action( 'widgets_init', 'ziptech_widgets_init' );
//function tag widgets
function ziptech_tag_cloud_widget($args) {
  	$args['number'] = 0; //adding a 0 will display all tags
  	$args['largest'] = 18; //largest tag
  	$args['smallest'] = 11; //smallest tag
  	$args['unit'] = 'px'; //tag font unit
  	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
  	$args['exclude'] = array(20, 80, 92); //exclude tags by ID
  	return $args;
}
add_filter( 'widget_tag_cloud_args', 'ziptech_tag_cloud_widget' );
function ziptech_excerpt() {
  $ziptech_redux_demo = get_option('redux_demo');
  if(isset($ziptech_redux_demo['blog_excerpt'])){
    $limit = $ziptech_redux_demo['blog_excerpt'];
  }else{
    $limit = 50;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function ziptech_excerpt2() {
  $ziptech_redux_demo = get_option('redux_demo');
  if(isset($ziptech_redux_demo['blog_excerpt2'])){
    $limit = $ziptech_redux_demo['blog_excerpt2'];
  }else{
    $limit = 14;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function ziptech_excerpt3() {
  $ziptech_redux_demo = get_option('redux_demo');
  if(isset($ziptech_redux_demo['services_excerpt'])){
    $limit = $ziptech_redux_demo['services_excerpt'];
  }else{
    $limit = 15;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function ziptech_excerpt4() {
  $ziptech_redux_demo = get_option('redux_demo');
  if(isset($ziptech_redux_demo['projects_excerpt'])){
    $limit = $ziptech_redux_demo['projects_excerpt'];
  }else{
    $limit = 10;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}

function ziptech_search_form( $form ) {
    $form = '
        <form action="' . esc_url(home_url('/')) . '">
            <input type="text" class="s-input-home" name="s" required value="' . get_search_query() . '" placeholder="'.esc_attr__('Search…', 'ziptech').'">
            <button class="btn-s-input" type="submit"><i class="base-icon-search-1"></i></button>
        </form>
	';
    return $form;
}
add_filter( 'get_search_form', 'ziptech_search_form' );
function ziptech_theme_comment($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>
    <?php if(get_avatar($comment,$size='100' )!=''){?>
      <li class="comment">
        <article class="comment-body">
          <div class="comment-author-thumb f-left">
            <img src="<?php echo get_template_directory_uri();?>/images/news/comment-img3.jpg" class="avatar" alt="image" />
          </div>
          <div class="comment-content">
            <h6 class="comment-author"><?php printf( get_comment_author_link()) ?></h6>
            <div class="comment-meta">
              <div class="comment-metadata">
                <a href="#">
                  <span>
                    <i class="far fa-calendar-alt text-primary-color mrr-5"></i>
                    <?php comment_time(get_option( 'date_format' ));?>
                  </span>
                </a>
              </div>
            </div>
            <div class="comment-text"><?php comment_text() ?></div>
            <div class="reply">
               <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </div>
          </div>
        </article>
      </li>
  <?php }else{?>
      <li class="comment">
        <article class="comment-body">
          <div class="comment-content">
            <h6 class="comment-author"><?php printf( get_comment_author_link()) ?></h6>
            <div class="comment-meta">
              <div class="comment-metadata">
                <a href="#">
                  <span>
                    <i class="far fa-calendar-alt text-primary-color mrr-5"></i>
                    <?php comment_time(get_option( 'date_format' ));?>
                  </span>
                </a>
              </div>
            </div>
            <div class="comment-text"><?php comment_text() ?></div>
            <div class="reply">
               <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </div>
          </div>
        </article>
      </li>
<?php }?>

<?php
}

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'ziptech_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
 
function ziptech_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
      array(
            'name'      => esc_html__( 'One Click Demo Import', 'ziptech' ),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Editor', 'ziptech' ),
            'slug'      => 'classic-editor',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Widgets', 'ziptech' ),
            'slug'      => 'classic-widgets',
            'required'  => true,
        ),
      array(
            'name'      => esc_html__( 'Widget Importer & Exporter', 'ziptech' ),
            'slug'      => 'widget-importer-&-exporter',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Contact Form 7', 'ziptech' ),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'WP Maximum Execution Time Exceeded', 'ziptech' ),
            'slug'      => 'wp-maximum-execution-time-exceeded',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'SVG Support', 'ziptech' ),
            'slug'      => 'svg-support',
            'required'  => true,
        ), 
      array(
            'name'                     => esc_html__( 'Elementor', 'ziptech' ),
            'slug'                     => 'elementor',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/elementor.zip',
        ),
      array(
            'name'                     => esc_html__( 'Ziptech Common', 'ziptech' ),
            'slug'                     => 'ziptech-common',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/ziptech-common.zip',
        ),
      array(
            'name'                     => esc_html__( 'Ziptech Elementor', 'ziptech' ),
            'slug'                     => 'ziptech-elementor',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/ziptech-elementor.zip',
        ),
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'ziptech' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'ziptech' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'ziptech' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'ziptech' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'ziptech' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'ziptech' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'ziptech' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'ziptech' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'ziptech' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'ziptech' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'ziptech' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'ziptech' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'ziptech' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'ziptech' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'ziptech' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'ziptech' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'ziptech' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}
?>