<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>

<?php if ( have_comments() ) : ?>
<h3 class="comments-title"><?php comments_number( esc_html__(' 0 Comments', 'ziptech'), esc_html__(' 1 Comment', 'ziptech'), esc_html__('% Comments', 'ziptech') ); ?></h3>
<ol class="comment-list">
    <?php wp_list_comments('callback=ziptech_theme_comment'); ?>
<ol>
<div class="col-md-12"> 
<!-- START PAGINATION -->
<?php
if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
?>
<div class="pagination_area">
     <nav>
          <ul class="pagination">
               <li> <?php paginate_comments_links( 
              array(
              'prev_text' => wp_specialchars_decode(esc_html__( '<i class="fa fa-angle-left"></i>', 'ziptech' ),ENT_QUOTES),
              'next_text' => wp_specialchars_decode(esc_html__( '<i class="fa fa-angle-right"></i>', 'ziptech' ),ENT_QUOTES),
              ));  ?>
                </li>
          </ul>
     </nav>
</div>                                       
<?php endif; ?>
<!-- END PAGINATION --> 
</div>
<?php endif; ?>     
<?php
    if ( is_singular() ) wp_enqueue_script( "comment-reply" );
$aria_req = ( $req ? " aria-required='true'" : '' );
$comment_args = array(
        'id_form' => 'contact-form',        
        'class_form' => 'white-field',                         
        'title_reply'=> wp_specialchars_decode(esc_html__( 'Leave A Comment', 'ziptech' ),ENT_QUOTES),
        'fields' => apply_filters( 'comment_form_default_fields', array(
            'author' => ' <div class="row"><div class="col-lg-6">
                            <div class="form-group mrb-20">
                              <input type="text" name="author" placeholder="'.esc_attr__('Name ', 'ziptech').'" class="form-control" required="'.esc_attr__('required', 'ziptech').'" data-error="'.esc_attr__('Name is required.', 'ziptech').'"/>
                            </div>
                          </div>
                        ',
            'email' => '<div class="col-lg-6">
                            <div class="form-group mrb-20">
                                <input type="email" name="email" placeholder="'.esc_attr__('Email', 'ziptech').'" required="'.esc_attr__('required', 'ziptech').'" data-error="'.esc_attr__('Valid email is required.', 'ziptech').'" class="form-control" />
                            </div>
                        </div></div>
                        ',
        ) ),   
            'comment_field' => '<div class="col-lg-12">
                                    <div class="form-group mrb-20">
                                        <textarea rows="8" name="comment" placeholder="'.esc_attr__('Write A Comment', 'ziptech').'" required="'.esc_attr__('required', 'ziptech').'" data-error="'.esc_attr__('Please,leave us a message.', 'ziptech').'" class="form-control"></textarea>
                                    </div>
                                </div>
                                ', 
                
        'label_submit' => esc_html__( 'Post A Comment', 'ziptech' ),
        'submit_button'=> '<button type="submit" class="theme-btn-1" id=" %2$s" >%4$s</button>',
        'submit_field' => '<div class="col-lg-8"><div class="form-group mrb-0">
                                %1$s %2$s
                          </div></div>',
        'comment_notes_before' => '',
        'comment_notes_after' => '',               
)
?>
<div class="reply-form mrt-40">
    <?php if ( comments_open() ) : ?>
        <?php comment_form($comment_args); ?>
    <?php endif; ?> 
</div>