<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
 $ziptech_redux_demo = get_option('redux_demo');
get_header(); ?> 
<?php if(isset($ziptech_redux_demo['error_image']['url']) && $ziptech_redux_demo['error_image']['url'] != ''){?> 
<div class="error-area vh d-flex" data-background="<?php echo esc_url($ziptech_redux_demo['error_image']['url']);?>" data-overlay-light="95">
<?php }else{?>
<div class="error-area vh d-flex" data-background="<?php echo get_template_directory_uri();?>/images/bg/404.jpg" data-overlay-light="95">
<?php } ?>
  <div class="container">
    <div class="row">
      <div class="col-xl-12">
        <div class="error-inner text-center">
          <h1 class="error-title"><?php if(isset($ziptech_redux_demo['404'])){?>
                        <?php echo esc_attr($ziptech_redux_demo['404']);?>
                        <?php }else{?>
                        <?php echo esc_html__( '4<span class="text-primary-color">0</span>4', 'ziptech' );
                        }
                        ?></h1>
          <h2 class="error-text"><?php if(isset($ziptech_redux_demo['page_not_found'])){?>
                        <?php echo esc_attr($ziptech_redux_demo['page_not_found']);?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Sorry, something went wrong!', 'ziptech' );
                        }
                        ?></h2>
          <p><?php if(isset($ziptech_redux_demo['desc_404'])){?>
                        <?php echo esc_attr($ziptech_redux_demo['desc_404']);?>
                        <?php }else{?>
                        <?php echo esc_html__( 'This page is temporarily unavailable due to maintenance. We will back very soon thanks for your patien', 'ziptech' ); }
                        ?></p>
          <a class="theme-btn-1" href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($ziptech_redux_demo['home_page'])){?>
                    <?php echo esc_attr($ziptech_redux_demo['home_page']);?>
                    <?php }else{?>
                    <?php echo esc_html__( 'Return Home', 'ziptech' );
                    }
                    ?></a>
        </div>
      </div>
    </div>
  </div>
</div>
<?php
get_footer(); ?> 
