<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsAboutSC extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-about-software-company';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'About Software Company', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs About widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs About widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'software-company' ];
	}

	public function get_keywords() {
		return [ 'About', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_Abouts',
			[
				'label' => esc_html__( 'Abouts', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'image',
			[
				'label'       => __( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			]
			);
		$this->add_control(
			'image2',
			[
				'label'       => __( 'Background Image 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'experience',
			[
				'label'       => __( 'Experience', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Experience', 'bdevs-elementor' ),
				'default'     => __( 'Years <br /> Experience', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'year',
			[
				'label'       => __( 'Year', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Year', 'bdevs-elementor' ),
				'default'     => __( '12', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'About Ziptech', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'Get Exclusive It Solutions & Services With Ziptech', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'bdevs-elementor' ),
				'default'     => __( 'Lorem ipsum dolor sit, amet consectetur adipisicing elit. Ad earum autem laboriosam asperiores dignissimos at tempore', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Abouts Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '24/7 Support' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Lorem ipsum dolor sit ame sedme consectetur nod.' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);
		$this->add_control(
			'tabs2',
			[
				'label' => esc_html__( 'Skill Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'        => 'skill_title',
						'label'       => esc_html__( 'Skill Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'It Services' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'count',
						'label'       => esc_html__( 'Count', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '70' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_experience',
			[
				'label'   => esc_html__( 'Show Experience', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_year',
			[
				'label'   => esc_html__( 'Show year', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Subtitle', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_skill_title',
			[
				'label'   => esc_html__( 'Show Skill Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_count',
			[
				'label'   => esc_html__( 'Show Count', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		
		
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		?> 
<section class="pdb-110 pdb-lg-50">
      <div class="container">
        <div class="row mrb-5">
          <div class="col-md-12 col-lg-6 col-xl-6 wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
            <div class="about-image-box-style4 dot-circle mrb-lg-60">
              <img class="about-image1 img-full js-tilt d-none d-md-block d-lg-block d-xl-block" src="<?php print esc_url($settings['image']['url']); ?>" alt="" />
              <img class="about-image2 img-full" src="<?php print esc_url($settings['image2']['url']); ?>" alt="" />
              <?php if (( '' !== $settings['experience'] ) && ( $settings['show_experience'] )) : ?>
              <div class="years-of-experience">
                <span class="count-text"><?php echo wp_kses_post($settings['year']); ?></span>
                <?php echo wp_kses_post($settings['experience']); ?>
              </div>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-md-12 col-lg-6 col-xl-6 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
            <div class="title-box">
            	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
              	<h5 class="side-line-left sub-title text-gradient-color"><?php echo wp_kses_post($settings['subheading']); ?></h5>
              	<?php endif; ?>
              	<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
	            <h2 class="title mrb-25"><?php echo wp_kses_post($settings['heading']); ?></h2>
	            <?php endif; ?>
            </div>
            <?php if (( '' !== $settings['desc'] ) && ( $settings['show_desc'] )) : ?>
            <p class="mrb-35"><?php echo wp_kses_post($settings['desc']); ?></p>
            <?php endif; ?>
            <div class="row">
              <div class="col-xl-6 col-lg-6 col-md-6">
              	<?php
			    	$idd = 0;
			    	foreach ( $settings['tabs'] as $item ) :
			    	$idd++;
				?>
	                <div class="about-style4-info-box">
	                	<?php if (( '' !== $settings['title'] ) && ( $settings['show_title'] )) : ?>
	                  	<h4 class="title"><span class="base-icon-radio-checked"></span> <?php echo wp_kses_post($item['title']); ?></h4>
	                  	<?php endif; ?>
	                  	<?php if (( '' !== $settings['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
	                  	<p class="text"><?php echo wp_kses_post($item['subtitle']); ?></p>
	                  	<?php endif; ?>
	                </div>
                <?php endforeach; ?>
              </div>
              <div class="col-xl-6 col-lg-6 col-md-6">
                <div class="skills2 white-bg mrb-md-45">
                	<?php
				    	$idd = 0;
				    	foreach ( $settings['tabs2'] as $item2 ) :
				    	$idd++;
					?>
                  <div class="skill-item">
                    <div class="skill-header">
                    	<?php if (( '' !== $settings['skill_title'] ) && ( $settings['show_skill_title'] )) : ?>
                      <h6 class="skill-title"><?php echo wp_kses_post($item2['skill_title']); ?></h6>
                      <?php endif; ?>
                      <?php if (( '' !== $settings['count'] ) && ( $settings['show_count'] )) : ?>
                      <div class="skill-percentage">
                        <div class="count-box"><span class="count-text" data-speed="2100" data-stop="<?php echo wp_kses_post($item2['count']); ?>">0</span>%</div>
                      </div>
                      <?php endif; ?>
                    </div>
                    <?php if (( '' !== $settings['count'] ) && ( $settings['show_count'] )) : ?>
                    <div class="skill-bar">
                      <div class="bar-inner">
                        <div class="bar progress-line" data-width="<?php echo wp_kses_post($item2['count']); ?>"></div>
                      </div>
                    </div>
                    <?php endif; ?>
                  </div>
                  <?php endforeach; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
	<?php
	}

}
