<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsProjectsPages extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-projects-pages';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Projects Pages Other Pages', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'other-pages' ];
	}

	public function get_keywords() {
		return [ 'Projects' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_Projects',
			[
				'label' => esc_html__( 'Projects', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'bg_image',
			[
				'label'       => __( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '6',
			]
		);
		$this->add_control(
			'orderpost',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'date'  => esc_html__( 'Date', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'rand' => esc_html__( 'Random', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);
		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		

		

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$wp_query = new \WP_Query(array('post_type' => 'projects','paged' => $paged, 'posts_per_page' => $settings['post_number'],'orderby' => $settings['orderby'], 'order' => $settings['orderpost'],));
		$ziptech_redux_demo = get_option('redux_demo');
		extract($settings);
	?> 
<section class="project-section pdt-105 pdb-80">
      <div class="section-content">
        <div class="container">
          <div class="row">
          	<?php
            while($wp_query->have_posts()): $wp_query->the_post();
            $cates = get_the_terms(get_the_ID(),'Type2');
                $cate_name = '';
                $cate_slug = '';
            foreach((array)$cates as $cate){
                if(count($cates)>0){
                    $cate_name .= $cate->name.' ';
                    $cate_slug .= $cate->slug.' ';
                }
            }
            ?>
            <?php $image_home = get_post_meta(get_the_ID(),'_cmb_image_home', true); ?>
            <?php $icon = get_post_meta(get_the_ID(),'_cmb_icon', true); ?>
            <div class="col-md-6 col-lg-6 col-xl-4 service-wrapper">
              <div class="project-item-style1">
                <span class="<?php echo esc_attr($icon);?>"></span>
                <div class="project-item-thumb">
                  <a class="project-item-link-image" href="<?php the_permalink();?>">
                    <img class="img-full" src="<?php echo wp_get_attachment_url($image_home);?>" alt="" />
                  </a>
                </div>
                <div class="project-item-details">
                  <div class="project-item-details-inner">
                    <h6 class="project-item-category"><a href="<?php the_permalink();?>"><?php echo esc_attr($cate_name);?></a></h6>
                    <h4 class="title"><?php the_title(); ?></h4>
                    <div class="project-item-link-icon">
                      <a href="<?php the_permalink();?>"><i class="base-icon-next"></i></a>
                    </div>
                  </div>
                </div>
                <div class="project-item-details-hover">
                  <div class="project-item-details-inner">
                    <h4 class="title"><?php the_title(); ?></h4>
                    <div class="desc"><?php if(isset($ziptech_redux_demo['projects_excerpt'])){?>
                            <?php echo esc_attr(ziptech_excerpt4($ziptech_redux_demo['projects_excerpt'])); ?>
                            <?php }else{?>
                            <?php echo esc_attr(ziptech_excerpt4(10)); } ?></div>
                    <div class="project-item-link-icon">
                      <a href="<?php the_permalink();?>"><i class="base-icon-next"></i></a>
                    </div>
                  </div>
                </div>
                <a class="bg-overlay" href="<?php the_permalink();?>"></a>
              </div>
            </div>
            <?php endwhile; ?>
          </div>
        </div>
      </div>
    </section>



	<?php
	}
}