<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsContactUs extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-contact-us';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Contact Us Other Pages', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'other-pages' ];
	}

	public function get_keywords() {
		return [ 'Contact' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_ContactUs',
			[
				'label' => esc_html__( 'Contact Us', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'bg_image',
			[
				'label'       => __( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Contact Us Info Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'        => 'icon',
						'label'       => esc_html__( 'Icon', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'base-icon-map' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Australia Address' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '121 King Street, Melbourne' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'Get In Touch', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'Have Any Questions?', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'facebook',
			[
				'label'       => __( 'Link Facebook', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Link Facebook', 'bdevs-elementor' ),
				'default'     => __( 'https://www.facebook.com/', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'twitter',
			[
				'label'       => __( 'Link Twitter', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Link Twitter', 'bdevs-elementor' ),
				'default'     => __( 'https://www.twitter.com/', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'instagram',
			[
				'label'       => __( 'Link Instagram', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Link Instagram', 'bdevs-elementor' ),
				'default'     => __( 'https://www.instagram.com/', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'google_plus',
			[
				'label'       => __( 'Link Google', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Link Google', 'bdevs-elementor' ),
				'default'     => __( 'https://www.google.com/', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'contact_form',
			[
				'label'       => __( 'Contact Form', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Contact Form', 'bdevs-elementor' ),
				'default'     => __( '[contact-form-7 id="301" title="Contact Us"]', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'map',
			[
				'label'       => __( 'Link Map', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Link Map', 'bdevs-elementor' ),
				'default'     => __( 'https://maps.google.com/maps?q=Graz&t=&z=11&ie=UTF8&iwloc=&output=embed', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_facebook',
			[
				'label'   => esc_html__( 'Show Facebook', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_instagram',
			[
				'label'   => esc_html__( 'Show Instagram', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_google_plus',
			[
				'label'   => esc_html__( 'Show google', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_map',
			[
				'label'   => esc_html__( 'Show Map', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
	?> 
<section class="contact-section bg-no-repeat bg-cover pdt-110 pdb-110" data-background="<?php print esc_url($settings['bg_image']['url']); ?>" data-overlay-light="2">
      <div class="container">
        <div class="row mrb-80">
          <div class="col-xl-12">
            <div class="row">
            	<?php
			    	$idd = 0;
			    	foreach ( $settings['tabs'] as $item ) :
			    	$idd++;
				?>
              <div class="col-lg-6 col-xl-4">
                <div class="contact-block d-flex mrb-30">
                  <div class="contact-icon">
                    <i class="<?php echo wp_kses_post($item['icon']); ?>"></i>
                  </div>
                  <div class="contact-details mrl-30">
                    <h5 class="icon-box-title mrb-10"><?php echo wp_kses_post($item['title']); ?></h5>
                    <p class="mrb-0"><?php echo wp_kses_post($item['subtitle']); ?></p>
                  </div>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-xl-5">
          	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
            <h5 class="side-line-left text-primary-color mrt-0 mrb-5"><?php echo wp_kses_post($settings['subheading']); ?></h5>
            <?php endif; ?>
            <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
            <h2 class="faq-title mrb-30"><?php echo wp_kses_post($settings['heading']); ?></h2>
            <?php endif; ?>
            <ul class="social-list list-lg list-primary-color list-flat mrb-lg-60 clearfix">
            	<?php if (( '' !== $settings['facebook'] ) && ( $settings['show_facebook'] )) : ?>
              <li>
                <a href="<?php echo wp_kses_post($settings['facebook']); ?>"><i class="fab fa-facebook"></i></a>
              </li>
              <?php endif; ?>
              <?php if (( '' !== $settings['twitter'] ) && ( $settings['show_twitter'] )) : ?>
              <li>
                <a href="<?php echo wp_kses_post($settings['twitter']); ?>"><i class="fab fa-twitter"></i></a>
              </li>
              <?php endif; ?>
              <?php if (( '' !== $settings['instagram'] ) && ( $settings['show_instagram'] )) : ?>
              <li>
                <a href="<?php echo wp_kses_post($settings['instagram']); ?>"><i class="fab fa-instagram"></i></a>
              </li>
              <?php endif; ?>
              <?php if (( '' !== $settings['google_plus'] ) && ( $settings['show_google_plus'] )) : ?>
              <li>
                <a href="<?php echo wp_kses_post($settings['google_plus']); ?>"><i class="fab fa-google-plus"></i></a>
              </li>
              <?php endif; ?>
            </ul>
          </div>
          <div class="col-xl-7">
            <div class="contact-form">
              <?php echo do_shortcode($settings['contact_form']); ?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Contact Section End -->
    <!-- Google Map Section Start -->
    <?php if (( '' !== $settings['map'] ) && ( $settings['show_map'] )) : ?>
    <section class="google-map-section">
      <!-- Google Map Start -->
      <div class="mapouter fixed-height">
        <div class="gmap_canvas">
          <iframe id="gmap_canvas" src="<?php echo wp_kses_post($settings['map']); ?>"></iframe>
          <a href="https://www.whatismyip-address.com"></a>
        </div>
      </div>
      <!-- Google Map End -->
    </section>
    <?php endif; ?>
	<?php
	}
}