<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsSliderIT extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-slider-it-solution';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Slider It Solutions', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'it-solutions' ];
	}

	public function get_keywords() {
		return [ 'slides', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_sliders',
			[
				'label' => esc_html__( 'Sliders', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'select',
			[
				'label'       => __( 'Choose Select', 'bdevs-elementor' ),
				'type'        => Controls_Manager::SELECT,
				'dynamic'     => [ 'active' => true ],
				'options'   => [
									'rtl'  => esc_html__( 'RTL', 'bdevs-elementor' ),
									'ltr' => esc_html__( 'LTR', 'bdevs-elementor' ),
								],
				'default'   => 'ltr',
				'label_block' => true,
			]
		);
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Slider Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'heading'   => esc_html__( 'Ziptech Provides Best IT Solution', 'bdevs-elementor' ),
						'subheading' => esc_html__( 'We provide best technology and IT services around the world with more than 30+ years of experience', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'    => 'image',
						'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
					],
					[
						'name'        => 'heading',
						'label'       => esc_html__( 'Heading', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Ziptech Provides Best IT Solution' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'subheading',
						'label'       => esc_html__( 'Subheading', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'We provide best technology and IT services around the world with more than 30+ years of experience' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'button',
						'label'       => esc_html__( 'Button', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Contact Us' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'link_button',
						'label'       => esc_html__( 'Link Button', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'https://shtheme.com/demosd/ziptech/?page_id=154' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'button2',
						'label'       => esc_html__( 'Button 2', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Read More' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'link_button2',
						'label'       => esc_html__( 'Link Button 2', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'https://shtheme.com/demosd/ziptech/?page_id=135' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_button2',
			[
				'label'   => esc_html__( 'Show Button 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		?> 
<?php if($settings['select']=='rtl') { ?>
<section class="home_banner_02_rtl">
      <div class="home-carousel owl-theme owl-carousel">
      	<?php
	    	$idd = 0;
	    	foreach ( $settings['tabs'] as $item ) :
	    	$idd++;
		?>
        <div class="slide-item">
          <div class="image-layer" data-background="<?php print esc_url($item['image']['url']); ?>"></div>
          <div class="shape1"></div>
          <div class="shape2"></div>
          <div class="auto-container">
            <div class="row clearfix justify-content-md-center">
              <div class="col-xl-8 col-lg-12 col-md-12 content-column">
                <div class="content-box">
                  	<?php if (( '' !== $item['heading'] ) && ( $settings['show_heading'] )) : ?>
	              	<h1 class="home-carousel-title"><?php echo wp_kses_post($item['heading']); ?></h1>
	              	<?php endif; ?>
	              	<?php if (( '' !== $item['subheading'] ) && ( $settings['show_subheading'] )) : ?>
	              	<p class="home-carousel-text"><?php echo wp_kses_post($item['subheading']); ?></p>
	              	<?php endif; ?>
                  	<div class="btn-box">
                    	<?php if (( '' !== $item['button'] ) && ( $settings['show_button'] )) : ?>
		                <a href="<?php echo wp_kses_post($item['link_button']); ?>" class="theme-btn-1 mrr-15"><?php echo wp_kses_post($item['button']); ?><i class="base-icon-next"></i></a>
		                <?php endif; ?>
		                <?php if (( '' !== $item['button2'] ) && ( $settings['show_button2'] )) : ?>
		                <a href="<?php echo wp_kses_post($item['link_button2']); ?>" class="theme-btn-8 d-none d-xl-inline-flex d-lg-inline-flex d-md-inline-flex"><?php echo wp_kses_post($item['button2']); ?></a>
		                <?php endif; ?>
                  	</div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
    </section>
<?php if (is_admin()) { ?>
<script type="text/javascript">
	var owl = $(".home_banner_02_rtl .home-carousel");
    owl.owlCarousel({
      loop:true,
      margin:0,
      nav:true,
      dots: false,
      animateOut: 'fadeOut',
      animateIn: 'fadeIn',
      active: true,
      autoplay: false,
      rtl: true,
      smartSpeed: 1000,
      autoplayTimeout: 8000,
      navText: ["<i class='base-icon-right-chevron'></i>", "<i class='base-icon-left-chevron'></i>"],
      responsive: {
        0: {
          items: 1
        },
        425: {
          items: 1
        },
        768: {
          items: 1
        },
        1024: {
          items: 1
        },
        1440: {
          items: 1
        }
      }
    });
</script>
<?php }  ?>
<?php } else { ?>
<section class="home_banner_02">
      <div class="home-carousel owl-theme owl-carousel">
      	<?php
	    	$idd = 0;
	    	foreach ( $settings['tabs'] as $item ) :
	    	$idd++;
		?>
        <div class="slide-item">
          <div class="image-layer" data-background="<?php print esc_url($item['image']['url']); ?>"></div>
          <div class="shape1"></div>
          <div class="shape2"></div>
          <div class="auto-container">
            <div class="row clearfix justify-content-md-center">
              <div class="col-xl-8 col-lg-12 col-md-12 content-column">
                <div class="content-box">
                  	<?php if (( '' !== $item['heading'] ) && ( $settings['show_heading'] )) : ?>
	              	<h1 class="home-carousel-title"><?php echo wp_kses_post($item['heading']); ?></h1>
	              	<?php endif; ?>
	              	<?php if (( '' !== $item['subheading'] ) && ( $settings['show_subheading'] )) : ?>
	              	<p class="home-carousel-text"><?php echo wp_kses_post($item['subheading']); ?></p>
	              	<?php endif; ?>
                  	<div class="btn-box">
                    	<?php if (( '' !== $item['button'] ) && ( $settings['show_button'] )) : ?>
		                <a href="<?php echo wp_kses_post($item['link_button']); ?>" class="theme-btn-1 mrr-15"><?php echo wp_kses_post($item['button']); ?><i class="base-icon-next"></i></a>
		                <?php endif; ?>
		                <?php if (( '' !== $item['button2'] ) && ( $settings['show_button2'] )) : ?>
		                <a href="<?php echo wp_kses_post($item['link_button2']); ?>" class="theme-btn-8 d-none d-xl-inline-flex d-lg-inline-flex d-md-inline-flex"><?php echo wp_kses_post($item['button2']); ?></a>
		                <?php endif; ?>
                  	</div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
    </section>
<?php if (is_admin()) { ?>
<script type="text/javascript">
	var owl = $(".home_banner_02 .home-carousel");
    owl.owlCarousel({
      loop:true,
      margin:0,
      nav:true,
      dots: false,
      animateOut: 'fadeOut',
      animateIn: 'fadeIn',
      active: true,
      autoplay: false,
      smartSpeed: 1000,
      autoplayTimeout: 8000,
      navText: ["<i class='base-icon-left-arrow'></i>", "<i class='base-icon-right-arrow'></i>"],
      responsive: {
        0: {
          items: 1
        },
        425: {
          items: 1
        },
        768: {
          items: 1
        },
        1024: {
          items: 1
        },
        1440: {
          items: 1
        }
      }
    });
</script>
<?php }  ?>
<?php }  ?>
	<?php
	}

}
