<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsAboutIT extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-about-it-solution';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'About It Solutions', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs About widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs About widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'it-solutions' ];
	}

	public function get_keywords() {
		return [ 'About', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_Abouts',
			[
				'label' => esc_html__( 'Abouts', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label'       => __( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'image',
			[
				'label'       => __( 'Image 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			]
			);
		
		
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'About Company', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'We Provide the best IT Solutions services', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'bdevs-elementor' ),
				'default'     => __( 'Lorem ipsum dolor sit, amet consectetur adipisicing elit. Ad earum autem laboriosam asperiores dignissimos at tempore', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Featured Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'        => 'icon',
						'label'       => esc_html__( 'Icon', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'webexflaticon webextheme-icon-032-brainstorming' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Exclusive Design' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Quickly productivate just in time strategic lacus mirina' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);
		$this->add_control(
			'tabs2',
			[
				'label' => esc_html__( 'Skill Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'        => 'title_skill',
						'label'       => esc_html__( 'Title Skill', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'It Services' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'number',
						'label'       => esc_html__( 'Number', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '85' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);
		$this->add_control(
			'image2',
			[
				'label'       => __( 'Image Right 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			]
			);
		$this->add_control(
			'image3',
			[
				'label'       => __( 'Image Right 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'experience',
			[
				'label'       => __( 'Experience', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Experience', 'bdevs-elementor' ),
				'default'     => __( 'We have more than years of experience', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'year',
			[
				'label'       => __( 'Year', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Year', 'bdevs-elementor' ),
				'default'     => __( '14+', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_text',
			[
				'label'   => esc_html__( 'Show Text', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_icon',
			[
				'label'   => esc_html__( 'Show Icon', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Subtitle', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_experience',
			[
				'label'   => esc_html__( 'Show Experience', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_year',
			[
				'label'   => esc_html__( 'Show year', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		?> 
<!-- About Section Start -->
    <section class="about-us-section-style2 pdt-80 pdb-95 bg-no-repeat bg-cover bg-pos-cb" data-background="<?php print esc_url($settings['bg_image']['url']); ?>" data-overlay-light="4">
      <div class="container">
        <div class="row">
          <div class="col-md-12 col-lg-10 col-xl-6 wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
          	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
            <h5 class="side-line-left subtitle text-primary-color"><?php echo wp_kses_post($settings['subheading']); ?></h5>
            <?php endif; ?>
            <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
            <h2 class="mrb-30"><?php echo wp_kses_post($settings['heading']); ?></h2>
            <?php endif; ?>
            <?php if (( '' !== $settings['desc'] ) && ( $settings['show_desc'] )) : ?>
            <p class="mrb-35"><?php echo wp_kses_post($settings['desc']); ?></p>
            <?php endif; ?>
            <div class="row no-gutters mrb-30 mrb-lg-40 mrb-sm-0">
              <div class="col-xl-5 col-lg-5 col-md-6 col-sm-6">
                <img class="img-full mrb-sm-40" src="<?php print esc_url($settings['image']['url']); ?>" alt="" />
              </div>
              <div class="col-xl-7 col-lg-7 col-md-6 col-sm-6">
              	<?php
			    	$idd = 0;
			    	foreach ( $settings['tabs'] as $item ) :
			    	$idd++;
				?>
                <div class="featured-icon-box mrb-15">
                  <div class="featured-icon">
                    <i class="<?php echo wp_kses_post($item['icon']); ?>"></i>
                  </div>
                  <div class="featured-content">
                  	<?php if (( '' !== $item['title'] ) && ( $settings['show_title'] )) : ?>
                    <h4 class="featured-title"><?php echo wp_kses_post($item['title']); ?></h4>
                    <?php endif; ?>
                    <?php if (( '' !== $item['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
                    <p class="featured-desc"><?php echo wp_kses_post($item['subtitle']); ?></p>
                    <?php endif; ?>
                  </div>
                </div>
                <?php endforeach; ?>
              </div>
            </div>
            <div class="row mrb-lg-60">
              <div class="col-xl-12 col-lg-12 col-md-12">
                <div class="skills2 white-bg mrb-md-45">
                	<?php
				    	$idd = 0;
				    	foreach ( $settings['tabs2'] as $item ) :
				    	$idd++;
					?>
                  <div class="skill-item">
                    <div class="skill-header">
                      <h6 class="skill-title"><?php echo wp_kses_post($item['title_skill']); ?></h6>
                      <div class="skill-percentage">
                        <div class="count-box"><span class="count-text" data-speed="2100" data-stop="<?php echo wp_kses_post($item['number']); ?>">0</span>%</div>
                      </div>
                    </div>
                    <div class="skill-bar">
                      <div class="bar-inner">
                        <div class="bar progress-line" data-width="<?php echo wp_kses_post($item['number']); ?>"></div>
                      </div>
                    </div>
                  </div>
                  <?php endforeach; ?>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-12 col-lg-8 col-xl-6 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
            <div class="about-image-box-style2 about-side-line mrr-60 mrr-lg-0">
              <figure class="about-image1 js-tilt d-none d-md-block d-lg-block d-xl-block">
                <img class="img-full" src="<?php print esc_url($settings['image2']['url']); ?>" alt="" />
              </figure>
              <figure class="about-image2">
                <img class="img-full" src="<?php print esc_url($settings['image3']['url']); ?>" alt="" />
              </figure>
              <div class="experience">
              	<?php if (( '' !== $settings['experience'] ) && ( $settings['show_experience'] )) : ?>
                <p class="experience-text"><?php echo wp_kses_post($settings['experience']); ?></p>
                <?php endif; ?>
                <?php if (( '' !== $settings['year'] ) && ( $settings['show_year'] )) : ?>
                <h4 class="experience-year"><?php echo wp_kses_post($settings['year']); ?></h4>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- About Section End -->
	<?php
	}

}
