<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsRequestACallDA extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-request-a-call-degital-agency';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Request a Call Digital Agency', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Client widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Client widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'degital-agency' ];
	}

	public function get_keywords() {
		return [ 'Client', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_Request_a_Call',
			[
				'label' => esc_html__( 'Request a Call', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'Get Quick Support', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'Request a Call Back', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'bdevs-elementor' ),
				'default'     => __( 'Nascetur cum integer potenti elementum fusce litora phasellus dignissim facilisi et inceptos malesuada', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'icon_contact_us',
			[
				'label'       => __( 'Icon Contact Us', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Icon Contact Us', 'bdevs-elementor' ),
				'default'     => __( 'base-icon-phone-call', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'contact_us',
			[
				'label'       => __( 'Title Contact Us', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title Contact Us', 'bdevs-elementor' ),
				'default'     => __( 'Call Us Now', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'contact_us_info1',
			[
				'label'       => __( ' Contact Us Information 1', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Contact Us Information 1', 'bdevs-elementor' ),
				'default'     => __( '+12 345 666 789', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'contact_us_info2',
			[
				'label'       => __( ' Contact Us Information 2', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Contact Us Information 2', 'bdevs-elementor' ),
				'default'     => __( '+00 256 335 887', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'icon_address',
			[
				'label'       => __( 'Icon Address', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Icon Address', 'bdevs-elementor' ),
				'default'     => __( 'base-icon-address', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'address',
			[
				'label'       => __( 'Title Address', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title Address', 'bdevs-elementor' ),
				'default'     => __( 'Office Address', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'address_info',
			[
				'label'       => __( ' Address Information', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Address Information', 'bdevs-elementor' ),
				'default'     => __( 'Level 5A, 32 Swanston Street Melbourne, 4778, Australia', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'contact_form',
			[
				'label'       => __( ' Contact Form', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Contact Form', 'bdevs-elementor' ),
				'default'     => __( '[contact-form-7 id="159" title="Request a Call Back"]', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_icon_contact_us',
			[
				'label'   => esc_html__( 'Show Icon Contact Us', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_contact_us',
			[
				'label'   => esc_html__( 'Show Contact Us', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_icon_address',
			[
				'label'   => esc_html__( 'Show Icon Address', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_address',
			[
				'label'   => esc_html__( 'Show Address', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		?> 
<section class="request-a-call-back-form-section-style3 pos-rel">
      <div class="container">
        <div class="request-a-call-back-form-style3">
          <div class="row">
            <div class="col-xl-5 col-lg-12">
            	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
              		<h5 class="side-line-left sub-title f-weight-700 text-gradient-color"><?php echo wp_kses_post($settings['subheading']); ?></h5>
              	<?php endif; ?>
              	<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
              	<h2 class="mrb-15"><?php echo wp_kses_post($settings['heading']); ?></h2>
              	<?php endif; ?>
              	<?php if (( '' !== $settings['desc'] ) && ( $settings['show_desc'] )) : ?>
              	<p class="mrb-45"><?php echo wp_kses_post($settings['desc']); ?></p>
              	<?php endif; ?>
              <div class="row mrb-lg-20">
                <div class="col-xl-6 col-lg-4 col-md-6">
                  <div class="contact-info">
                  	<?php if (( '' !== $settings['icon_contact_us'] ) && ( $settings['show_icon_contact_us'] )) : ?>
                    <div class="contact-info-icon">
                      <i class="<?php echo wp_kses_post($settings['icon_contact_us']); ?>"></i>
                    </div>
                    <?php endif; ?>
                    <div class="contact-info-content">
                    	<?php if (( '' !== $settings['contact_us'] ) && ( $settings['show_contact_us'] )) : ?>
                      	<h4 class="title"><?php echo wp_kses_post($settings['contact_us']); ?></h4>
                      	<?php endif; ?>
                      <ul>
                        <li><a class="tel-number text-webex-secondary-color" href="tel:<?php echo wp_kses_post($settings['contact_us_info1']); ?>"><?php echo wp_kses_post($settings['contact_us_info1']); ?></a></li>
                        <li><a class="tel-number text-webex-secondary-color" href="tel:<?php echo wp_kses_post($settings['contact_us_info2']); ?>"><?php echo wp_kses_post($settings['contact_us_info2']); ?></a></li>
                      </ul>
                    </div>
                  </div>
                </div>
                <div class="col-xl-6 col-lg-4 col-md-6">
                  <div class="contact-info">
                  	<?php if (( '' !== $settings['icon_address'] ) && ( $settings['show_icon_address'] )) : ?>
                    <div class="contact-info-icon">
                      <i class="<?php echo wp_kses_post($settings['icon_address']); ?>"></i>
                    </div>
                    <?php endif; ?>
                    <div class="contact-info-content">
                    	<?php if (( '' !== $settings['address'] ) && ( $settings['show_address'] )) : ?>
                      <h4 class="title"><?php echo wp_kses_post($settings['address']); ?></h4>
                      <?php endif; ?>
                      <p><?php echo wp_kses_post($settings['address_info']); ?></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col"></div>
            <div class="col-xl-6 col-lg-12 align-self-center">
              <div class="request-a-call-back-form">
                <?php echo do_shortcode($settings['contact_form']); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
	<?php
	}

}
