<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsServices2BC extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-services2-business-consulting';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Services2 Business Consulting', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Services widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Services widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'business-consulting' ];
	}

	public function get_keywords() {
		return [ 'Services', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_Servicess2',
			[
				'label' => esc_html__( 'Servicess', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label'       => __( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'Our Services', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'We Offer Exclusive IT Services', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'title_big_text',
			[
				'label'       => __( 'Title Big Text', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title Big Text', 'bdevs-elementor' ),
				'default'     => __( 'Services', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '8',
			]
		);
		$this->add_control(
			'orderpost',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'date'  => esc_html__( 'Date', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'rand' => esc_html__( 'Random', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);
		$this->add_control(
			'read_more',
			[
				'label'       => __( ' Read More', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Read More', 'bdevs-elementor' ),
				'default'     => __( 'Read More', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title_big_text',
			[
				'label'   => esc_html__( 'Show Title Big Text', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_read_more',
			[
				'label'   => esc_html__( 'Show Read More', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$wp_query = new \WP_Query(array('post_type' => 'services','paged' => $paged, 'posts_per_page' => $settings['post_number'],'orderby' => $settings['orderby'], 'order' => $settings['orderpost'],));
		$ziptech_redux_demo = get_option('redux_demo');
		extract($settings);
		?>
<section class="service-section-style3 bg-silver bg-no-repeat bg-pos-cb pdt-110 pdb-90" data-background="<?php print esc_url($settings['bg_image']['url']); ?>" data-overlay-light="2">
  <div class="section-title text-center wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
    <div class="container">
      <div class="row">
        <div class="col"></div>
        <div class="col-md-12 col-lg-10 col-xl-6">
      		<div class="title-box-center">
            	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
	            <h5 class="sub-title mrb-10"><?php echo wp_kses_post($settings['subheading']); ?></h5>
	            <?php endif; ?>
	            <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
	            <h2 class="title"><?php echo wp_kses_post($settings['heading']); ?></h2>
	            <?php endif; ?>
	            <?php if (( '' !== $settings['title_big_text'] ) && ( $settings['show_title_big_text'] )) : ?>
	            <div class="section-title-big_text"><?php echo wp_kses_post($settings['title_big_text']); ?></div>
	            <?php endif; ?>
          	</div>
        </div>
        <div class="col"></div>
      </div>
    </div>
  </div>
  <div class="section-content">
    <div class="container">
      <div class="row">
      	<?php
  	        $i=0;
  	        while($wp_query->have_posts()): $wp_query->the_post();
  	    	$ziptech_redux_demo = get_option('redux_demo');
  	    ?> 
  	    <?php $icon = get_post_meta(get_the_ID(),'_cmb_icon', true); ?>
        <div class="col-xl-3 col-lg-6 col-md-6">
          <div class="service-style3">
            <div class="service-inner">
              <i class="service-icon <?php echo esc_attr($icon);?>"></i>
              <h4 class="service-title"><?php the_title(); ?></h4>
              <p class="service-description"><?php if(isset($ziptech_redux_demo['services_excerpt'])){?>
                            <?php echo esc_attr(ziptech_excerpt3($ziptech_redux_demo['services_excerpt'])); ?>
                            <?php }else{?>
                            <?php echo esc_attr(ziptech_excerpt3(15)); } ?></p>
                <?php if (( '' !== $settings['read_more'] ) && ( $settings['show_read_more'] )) : ?>
              <a class="theme-text-icon-btn services-link icon-left" href="<?php the_permalink();?>">
                <span><?php echo wp_kses_post($settings['read_more']); ?></span>
                <i aria-hidden="true" class="base-icon-next"></i>
              </a>
              	<?php endif; ?>
              <div class="service-inner-obj"></div>
            </div>
          </div>
        </div>
        <?php endwhile; ?>
      </div>
    </div>
  </div>
</section>


	<?php
	}

}
