<?php
/**
 * Plugin Name: Meta Box
 * Plugin URI:  https://metabox.io
 * Description: Create custom meta boxes and custom fields in WordPress.
 * Version:     5.3.3
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * License:     GPL2+
 * Text Domain: meta-box
 * Domain Path: /languages/
 *
 * @package Meta Box
 */

if ( defined( 'ABSPATH' ) && ! defined( 'RWMB_VER' ) ) {
	register_activation_hook( __FILE__, 'rwmb_check_php_version' );

	/**
	 * Display notice for old PHP version.
	 */
	function rwmb_check_php_version() {
		if ( version_compare( phpversion(), '5.3', '<' ) ) {
			die( esc_html__( 'Meta Box requires PHP version 5.3+. Please contact your host to upgrade.', 'meta-box' ) );
		}
	}




	require_once dirname( __FILE__ ) . '/inc/loader.php';
	$rwmb_loader = new RWMB_Loader();
	$rwmb_loader->init();


	add_filter( 'rwmb_meta_boxes', function ( $meta_boxes ) {

	$prefix = '_cmb_';


  // Open Code


    $meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('post'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Featured Image Details',
                'desc' => 'Show in Featured Image Details',
                'id'   => $prefix . 'image_single',
                'type'    => 'file',
            ),
            array(
                'name' => 'Featured Image Recent Post',
                'desc' => 'Show in Featured Image Recent Post',
                'id'   => $prefix . 'img_recent',
                'type'    => 'file',
            ),
            array(
                'name' => 'Title Recent Post',
                'desc' => 'Show in Title Recent Post',
                'id'   => $prefix . 'title_recent',
                'type'    => 'text',
            ),
        )
    );

    $meta_boxes[] = array(
        'id'         => 'services_setting',
        'title'      => 'Services Setting',
        'pages'      => array('services'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Icon Details',
                'desc' => 'Show in Icon Details',
                'id'   => $prefix . 'icon',
                'type'    => 'text',
            ),
            array(
                'name' => 'Image Home',
                'desc' => 'Show in Image Home',
                'id'   => $prefix . 'image_home',
                'type'    => 'file',
            ),
            array(
                'name' => 'Image Home Small',
                'desc' => 'Show in Image Home Small',
                'id'   => $prefix . 'image_home_sm',
                'type'    => 'file',
            ),
        )
    );
    $meta_boxes[] = array(
        'id'         => 'projects_setting',
        'title'      => 'Projects Setting',
        'pages'      => array('projects'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Icon ',
                'desc' => 'Show in Icon ',
                'id'   => $prefix . 'icon',
                'type'    => 'text',
            ),
            array(
                'name' => 'Featured Image Home',
                'desc' => 'Show in Featured Image Home',
                'id'   => $prefix . 'image_home',
                'type'    => 'file',
            ),
            array(
                'name' => 'Featured Image Home Saas Landing',
                'desc' => 'Show in Featured Image Home',
                'id'   => $prefix . 'image_home_saas',
                'type'    => 'file',
            ),
        )
    );
    $meta_boxes[] = array(
        'id'         => 'team_setting',
        'title'      => 'Team Setting',
        'pages'      => array('Team'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Link Facebook',
                'desc' => 'Show in Link Facebook',
                'id'   => $prefix . 'facebook',
                'type'    => 'text',
            ),
            array(
                'name' => 'Link Instagram',
                'desc' => 'Show in Link Instagram',
                'id'   => $prefix . 'instagram',
                'type'    => 'text',
            ),
            array(
                'name' => 'Link Twitter',
                'desc' => 'Show in Link Twitter',
                'id'   => $prefix . 'twitter',
                'type'    => 'text',
            ),
            array(
                'name' => 'Link Behance',
                'desc' => 'Show in Link Behance',
                'id'   => $prefix . 'behance',
                'type'    => 'text',
            ),
        )
    );
    
    

    
// End Code



    return $meta_boxes;
});
}
