<?php
add_action( 'init', 'register_ziptech_services' );
function register_ziptech_services() {
    
$labels = array( 
    'name' => __( 'Services', 'ziptech' ),
    'singular_name' => __( 'Services', 'ziptech' ),
    'add_new' => __( 'Add New Services', 'ziptech' ),
    'add_new_item' => __( 'Add New Services', 'ziptech' ),
    'edit_item' => __( 'Edit Services', 'ziptech' ),
    'new_item' => __( 'New Services', 'ziptech' ),
    'view_item' => __( 'View Services', 'ziptech' ),
    'search_items' => __( 'Search Services', 'ziptech' ),
    'not_found' => __( 'No Services found', 'ziptech' ),
    'not_found_in_trash' => __( 'No Services found in Trash', 'ziptech' ),
    'parent_item_colon' => __( 'Parent Services:', 'ziptech' ),
    'menu_name' => __( 'Services', 'ziptech' ),
);

$args = array( 
    'labels' => $labels,
    'hierarchical' => true,
    'description' => 'List services',
    'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
    'taxonomies' => array( 'services', 'type1' ),
    'public' => true,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 5,
    'menu_icon' => 'dashicons-id-alt', 
    'show_in_nav_menus' => true,
    'publicly_queryable' => true,
    'exclude_from_search' => false,
    'has_archive' => true,
    'query_var' => true,
    'can_export' => true,
    'rewrite' => true,
    'capability_type' => 'post'
);

register_post_type( 'services', $args );
}
add_action( 'init', 'create_Type1_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_Type1_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

$labels = array(
    'name' => __( 'Type1', 'ziptech' ),
    'singular_name' => __( 'Type1', 'ziptech' ),
    'search_items' =>  __( 'Search Type1','ziptech' ),
    'all_items' => __( 'All Type1','ziptech' ),
    'parent_item' => __( 'Parent Type1','ziptech' ),
    'parent_item_colon' => __( 'Parent Type1:','ziptech' ),
    'edit_item' => __( 'Edit Type1','ziptech' ), 
    'update_item' => __( 'Update Type1','ziptech' ),
    'add_new_item' => __( 'Add New Type1','ziptech' ),
    'new_item_name' => __( 'New Type1 Name','ziptech' ),
    'menu_name' => __( 'Type1','ziptech' ),
  );     

// Now register the taxonomy

  register_taxonomy('type1',array('services'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type1' ),
  ));

}

add_action( 'init', 'register_ziptech_Projects' );
function register_ziptech_Projects() {
    
$labels = array( 
    'name' => __( 'Projects', 'ziptech' ),
    'singular_name' => __( 'Projects', 'ziptech' ),
    'add_new' => __( 'Add New Projects', 'ziptech' ),
    'add_new_item' => __( 'Add New Projects', 'ziptech' ),
    'edit_item' => __( 'Edit Projects', 'ziptech' ),
    'new_item' => __( 'New Projects', 'ziptech' ),
    'view_item' => __( 'View Projects', 'ziptech' ),
    'search_items' => __( 'Search Projects', 'ziptech' ),
    'not_found' => __( 'No Projects found', 'ziptech' ),
    'not_found_in_trash' => __( 'No Projects found in Trash', 'ziptech' ),
    'parent_item_colon' => __( 'Parent Projects:', 'ziptech' ),
    'menu_name' => __( 'Projects', 'ziptech' ),
);

$args = array( 
    'labels' => $labels,
    'hierarchical' => true,
    'description' => 'List Projects',
    'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
    'taxonomies' => array( 'Projects', 'Type2' ),
    'public' => true,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 5,
    'menu_icon' => 'dashicons-id-alt', 
    'show_in_nav_menus' => true,
    'publicly_queryable' => true,
    'exclude_from_search' => false,
    'has_archive' => true,
    'query_var' => true,
    'can_export' => true,
    'rewrite' => true,
    'capability_type' => 'post'
);

register_post_type( 'Projects', $args );
}
add_action( 'init', 'create_Type2_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_Type2_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

$labels = array(
    'name' => __( 'Type2', 'ziptech' ),
    'singular_name' => __( 'Type2', 'ziptech' ),
    'search_items' =>  __( 'Search Type2','ziptech' ),
    'all_items' => __( 'All Type2','ziptech' ),
    'parent_item' => __( 'Parent Type2','ziptech' ),
    'parent_item_colon' => __( 'Parent Type2:','ziptech' ),
    'edit_item' => __( 'Edit Type2','ziptech' ), 
    'update_item' => __( 'Update Type2','ziptech' ),
    'add_new_item' => __( 'Add New Type2','ziptech' ),
    'new_item_name' => __( 'New Type2 Name','ziptech' ),
    'menu_name' => __( 'Type2','ziptech' ),
  );     

// Now register the taxonomy

  register_taxonomy('Type2',array('Projects'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'Type2' ),
  ));

}

add_action( 'init', 'register_ziptech_Team' );
function register_ziptech_Team() {
    
$labels = array( 
    'name' => __( 'Team', 'ziptech' ),
    'singular_name' => __( 'Team', 'ziptech' ),
    'add_new' => __( 'Add New Team', 'ziptech' ),
    'add_new_item' => __( 'Add New Team', 'ziptech' ),
    'edit_item' => __( 'Edit Team', 'ziptech' ),
    'new_item' => __( 'New Team', 'ziptech' ),
    'view_item' => __( 'View Team', 'ziptech' ),
    'search_items' => __( 'Search Team', 'ziptech' ),
    'not_found' => __( 'No Team found', 'ziptech' ),
    'not_found_in_trash' => __( 'No Team found in Trash', 'ziptech' ),
    'parent_item_colon' => __( 'Parent Team:', 'ziptech' ),
    'menu_name' => __( 'Team', 'ziptech' ),
);

$args = array( 
    'labels' => $labels,
    'hierarchical' => true,
    'description' => 'List Team',
    'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
    'taxonomies' => array( 'Team', 'Type3' ),
    'public' => true,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 5,
    'menu_icon' => 'dashicons-id-alt', 
    'show_in_nav_menus' => true,
    'publicly_queryable' => true,
    'exclude_from_search' => false,
    'has_archive' => true,
    'query_var' => true,
    'can_export' => true,
    'rewrite' => true,
    'capability_type' => 'post'
);

register_post_type( 'Team', $args );
}
add_action( 'init', 'create_Type3_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_Type3_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

$labels = array(
    'name' => __( 'Type3', 'ziptech' ),
    'singular_name' => __( 'Type3', 'ziptech' ),
    'search_items' =>  __( 'Search Type3','ziptech' ),
    'all_items' => __( 'All Type3','ziptech' ),
    'parent_item' => __( 'Parent Type3','ziptech' ),
    'parent_item_colon' => __( 'Parent Type3:','ziptech' ),
    'edit_item' => __( 'Edit Type3','ziptech' ), 
    'update_item' => __( 'Update Type3','ziptech' ),
    'add_new_item' => __( 'Add New Type3','ziptech' ),
    'new_item_name' => __( 'New Type3 Name','ziptech' ),
    'menu_name' => __( 'Type3','ziptech' ),
  );     

// Now register the taxonomy

  register_taxonomy('Type3',array('Team'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'Type3' ),
  ));

}
?>