<?php
/**
 * Plugin Name: Ziptech Elementor
 * Description: Create unlimited widgets with Elementor Page Builder.
 * Plugin URI:  http://shtheme.com/
 * Version:     1.0.0
 * Author:      Nasir Uddin Mandal
 * Author URI:  http://shtheme.com
 * Text Domain: bdevs-elementor
 * Domain Path: /languages/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Main Bdevs Elementor Class
 *
 * The main class that initiates and runs the plugin.
 *
 * @since 1.0.0
 */
final class BdevsElementor {

	/**
	 * Plugin Version
	 *
	 * @since 1.0.0
	 *
	 * @var string The plugin version.
	 */
	const VERSION = '1.0.0';

	/**
	 * Minimum Elementor Version
	 *
	 * @since 1.0.0
	 *
	 * @var string Minimum Elementor version required to run the plugin.
	 */
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';

	/**
	 * Minimum PHP Version
	 *
	 * @since 1.0.0
	 *
	 * @var string Minimum PHP version required to run the plugin.
	 */
	const MINIMUM_PHP_VERSION = '5.5';

	/**
	 * Instance
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 * @static
	 *
	 * @var BdevsElementor The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 * @static
	 *
	 * @return BdevsElementor An instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {

		add_action( 'init', [ $this, 'i18n' ] );
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	/**
	 * Load Textdomain
	 *
	 * Load plugin localization files.
	 *
	 * Fired by `init` action hook.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function i18n() {

		load_plugin_textdomain( 'bdevs-elementor' );

	}

	/**
	 * Initialize the plugin
	 *
	 * Load the plugin only after Elementor (and other plugins) are loaded.
	 * Checks for basic plugin requirements, if one check fail don't continue,
	 * if all check have passed load the files required to run the plugin.
	 *
	 * Fired by `plugins_loaded` action hook.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function init() {

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		add_action( 'elementor/init', [ $this, 'add_elementor_category' ], 1 );

		// Add Plugin actions
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'register_frontend_scripts' ], 10 );

		// Register Widget Styles
		add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'register_frontend_styles' ] );

		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );

		// Register controls
		//add_action( 'elementor/controls/controls_registered', [ $this, 'register_controls' ] );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'bdevs-elementor' ),
			'<strong>' . esc_html__( 'Ziptech Elementor', 'bdevs-elementor' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'bdevs-elementor' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'bdevs-elementor' ),
			'<strong>' . esc_html__( 'Ziptech Elementor', 'bdevs-elementor' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'bdevs-elementor' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'bdevs-elementor' ),
			'<strong>' . esc_html__( 'Ziptech Elementor', 'bdevs-elementor' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'bdevs-elementor' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Add Elementor category.
	 */
	public function add_elementor_category() {
    	\Elementor\Plugin::instance()->elements_manager->add_category('bdevs-elementor',
	      	array(
					'title' => __( 'Ziptech Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	    \Elementor\Plugin::instance()->elements_manager->add_category('main-layout',
	      	array(
					'title' => __( 'Home Main Layout Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	    \Elementor\Plugin::instance()->elements_manager->add_category('it-solutions',
	      	array(
					'title' => __( 'Home It Solutions Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	    \Elementor\Plugin::instance()->elements_manager->add_category('degital-agency',
	      	array(
					'title' => __( 'Home Digital Agency Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	    \Elementor\Plugin::instance()->elements_manager->add_category('software-company',
	      	array(
					'title' => __( 'Home Software Company Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	    \Elementor\Plugin::instance()->elements_manager->add_category('saas-landing',
	      	array(
					'title' => __( 'Home SaaS Landing Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	    \Elementor\Plugin::instance()->elements_manager->add_category('business-consulting',
	      	array(
					'title' => __( 'Home Business Consulting Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	    \Elementor\Plugin::instance()->elements_manager->add_category('other-pages',
	      	array(
					'title' => __( 'Other Pages Elementor', 'bdevs-elementor' ),
					'icon'  => 'fa fa-plug',
	      	) 
	    );
	}

	/**
	* Register Frontend Scripts
	*
	*/
	public function register_frontend_scripts() {
	wp_register_script( 'bdevs-elementor', plugin_dir_url( __FILE__ ) . 'assets/js/bdevs-elementor.js', array( 'jquery' ), self::VERSION );
	}


	/**
	* Register Frontend styles
	*
	*/
	public function register_frontend_styles() {
	wp_register_style( 'bdevs-elementor', plugin_dir_url( __FILE__ ) . 'assets/css/bdevs-elementor.css', self::VERSION );
	}




	/**
	 * Init Widgets
	 *
	 * Include widgets files and register them
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function init_widgets() {

		// Include Widget files
		// Main Layout
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/slider-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/about-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/client-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/services-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/why-choose-us-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/request-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/team-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/projects-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/funfact-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/testimonial-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/main-layout/blog-widget.php';
		// IT Solutions
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/slider-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/feature-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/about-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/services-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/team-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/testimonial-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/get-a-quote-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/client-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/pricing-it-solution-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/it-solutions/blog-it-solution-widget.php';
		// Digital Agency
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/slider-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/services-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/about-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/funfact-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/projects-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/team-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/working-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/why-choose-us-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/request-a-call-degital-agency-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/degital-agency/blog-degital-agency-widget.php';
		// Software Company
		require_once plugin_dir_path( __FILE__ ) . 'widgets/software-company/slider-software-company-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/software-company/feature-software-company-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/software-company/about-software-company-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/software-company/services-software-company-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/software-company/funfact-software-company-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/software-company/projects-software-company-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/software-company/working-software-company-widget.php';
		// SaaS Landing
		require_once plugin_dir_path( __FILE__ ) . 'widgets/saas-landing/slider-saas-landing-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/saas-landing/services-saas-landing-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/saas-landing/feature-saas-landing-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/saas-landing/projects-saas-landing-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/saas-landing/testimonial-saas-landing-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/saas-landing/funfact-saas-landing-widget.php';
		// Business Consulting
		require_once plugin_dir_path( __FILE__ ) . 'widgets/business-consulting/slider-business-consulting-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/business-consulting/services-business-consulting-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/business-consulting/about-business-consulting-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/business-consulting/funfact-business-consulting-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/business-consulting/services2-business-consulting-widget.php';
		// Other Pages
		require_once plugin_dir_path( __FILE__ ) . 'widgets/other-pages/banner-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/other-pages/team-grid-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/other-pages/team-carousel-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/other-pages/faqs-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/other-pages/projects-pages-widget.php';
		require_once plugin_dir_path( __FILE__ ) . 'widgets/other-pages/contact-us-widget.php';


		// Register widget
		// Main Layout
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsSlider() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsAbout() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsClient() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsServices() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsWhyChooseUs() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsRequest() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTeam() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsProjects() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFunfact() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTestimonial() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsBlog() );
		// IT Solutions
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsSliderIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFeatureIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsAboutIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsServicesIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTeamIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTestimonialIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsQuoteIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsClientIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsPricingIT() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsBlogIT() );
		// Digital Agency
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsSliderDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsServicesDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsAboutDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFunfactDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsProjectDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTeamDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsWorkingDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsWhyChooseUsDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsRequestACallDA() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsBlogDA() );
		// Software Company
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsSliderSC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFeatureSC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsAboutSC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsServicesSC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFunfactSC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsProjectSC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsWorkingSC() );
		// SaaS Landing
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsSliderSL() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsServicesSL() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFeatureSL() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsProjectsSL() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTestimonialSL() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFunfactSL() );
		// Business Consulting
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsSliderBC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsServicesBC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsAboutBC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFunfactBC() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsServices2BC() );
		// Other Pages
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsBanner() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTeamGrid() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsTeamCarousel() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsFAQS() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsProjectsPages() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \BdevsElementor\Widget\BdevsContactUs() );


	}

	/** 
	 * register_controls description
	 * @return [type] [description]
	 */
	public function register_controls() {

		$controls_manager = \Elementor\Plugin::$instance->controls_manager;
		$controls_manager->register_control( 'slider-widget', new Test_Control1() );
	
	}

	/**
	 * Prints the Elementor Page content.
	 */
	public static function get_content( $id = 0 ) {
		if ( class_exists( '\ElementorPro\Plugin' ) ) {
			echo do_shortcode( '[elementor-template id="' . $id . '"]' );
		} else {
			echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $id );
		}
	}

}

BdevsElementor::instance();
