<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsTeamDA extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-team-degital-agency';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Team Digital Agency', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'degital-agency' ];
	}

	public function get_keywords() {
		return [ 'team' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_team',
			[
				'label' => esc_html__( 'Team', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub subheading', 'bdevs-elementor' ),
				'default'     => __( 'Meet Our Team', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);		
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'Let is See Our Expert Engineers', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'title_big_text',
			[
				'label'       => __( 'Title Big Text', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title Big Text', 'bdevs-elementor' ),
				'default'     => __( 'Team', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '6',
			]
		);
		$this->add_control(
			'orderpost',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'date'  => esc_html__( 'Date', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'rand' => esc_html__( 'Random', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);
		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title_big_text',
			[
				'label'   => esc_html__( 'Show Title Big Text', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$wp_query = new \WP_Query(array('post_type' => 'team','paged' => $paged, 'posts_per_page' => $settings['post_number'],'orderby' => $settings['orderby'], 'order' => $settings['orderpost'],));
		extract($settings);
	?> 
<section class="team-section pos-rel pdt-80 pdb-80">
      <div class="section-title text-center wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
        <div class="container">
          <div class="row">
            <div class="col"></div>
            <div class="col-md-12 col-lg-10 col-xl-6">
              <div class="title-box-center">
                <?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                <h5 class="sub-title mrb-10"><?php echo wp_kses_post($settings['subheading']); ?></h5>
                <?php endif; ?>
                <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                <h2 class="title"><?php echo wp_kses_post($settings['heading']); ?></h2>
                <?php endif; ?>
                <?php if (( '' !== $settings['title_big_text'] ) && ( $settings['show_title_big_text'] )) : ?>
                <div class="section-title-big_text"><?php echo wp_kses_post($settings['title_big_text']); ?></div>
            	<?php endif; ?>
              </div>
            </div>
            <div class="col"></div>
          </div>
        </div>
      </div>
      <div class="section-content">
        <div class="container">
          <div class="team-style1-wrapper">
            <div class="row">
              <div class="owl-carousel item_4col">
              	<?php
			        $i=0;
			        while($wp_query->have_posts()): $wp_query->the_post();
			        $cates = get_the_terms(get_the_ID(),'Type3');
		            $cate_name = '';
		            $cate_slug = '';
		            foreach((array)$cates as $cate){
		            	if(count($cates)>0){
		                $cate_name .= $cate->name.' ';
		                $cate_slug .= $cate->slug.' ';
		            }
			    	$ziptech_redux_demo = get_option('redux_demo');
			    ?> 
			    <?php $facebook = get_post_meta(get_the_ID(),'_cmb_facebook', true); ?>
			    <?php $instagram = get_post_meta(get_the_ID(),'_cmb_instagram', true); ?>
			    <?php $twitter = get_post_meta(get_the_ID(),'_cmb_twitter', true); ?>
			    <?php $behance = get_post_meta(get_the_ID(),'_cmb_behance', true); ?>
                <div class="team-style1 mrb-30">
                  <div class="team-upper-part">
                    <img class="img-full" src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="" />
                    <div class="team-social">
                      <i class="base-icon-share2"></i>
                      <ul class="social-list">
                        <?php if($facebook !='' ) { ?>
                        <li>
                          <a target="_blank" href="<?php echo esc_attr($facebook);?>">
                            <i class="base-icon-facebook"></i>
                          </a>
                        </li>
                    	<?php } ?>
                    	<?php if($instagram !='' ) { ?>
                        <li>
                          <a target="_blank" href="<?php echo esc_attr($instagram);?>">
                            <i class="base-icon-instagram"></i>
                          </a>
                        </li>
                        <?php } ?>
                        <?php if($twitter !='' ) { ?>
                        <li>
                          <a target="_blank" href="<?php echo esc_attr($twitter);?>">
                            <i class="base-icon-twitter"></i>
                          </a>
                        </li>
                        <?php } ?>
                        <?php if($behance !='' ) { ?>
                        <li>
                          <a target="_blank" href="<?php echo esc_attr($behance);?>">
                            <i class="base-icon-behance"></i>
                          </a>
                        </li>
                        <?php } ?>
                      </ul>
                    </div>
                  </div>
                  <div class="team-bottom-part">
                    <h4 class="team-title"><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h4>
                    <p class="designation"><?php echo esc_attr($cate_name);?></p>
                  </div>
                </div>
                <?php } ?>
                <?php endwhile; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
	<?php
	}
}