<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsFeatureSL extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-feature-saas-landing';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Feature SaaS Landing', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Feature widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Feature widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'saas-landing' ];
	}

	public function get_keywords() {
		return [ 'slides', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_SaaS_Landing',
			[
				'label' => esc_html__( 'Features', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label'       => __( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Features Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'heading'   => esc_html__( 'Ziptech Provides Best IT Solution', 'bdevs-elementor' ),
						'subheading' => esc_html__( 'We provide best technology and IT services around the world with more than 30+ years of experience', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'    => 'image',
						'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
					],
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'About Ziptech' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Efficient and faster way to work together' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					
					[
						'name'        => 'desc',
						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Perferendis Ipsum voluptatibus consectetur adipisicing elit voluptatibus pariatur architecto dolorum perferendis distinctio tempora, necessitatibus omnis magnam.' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'button',
						'label'       => esc_html__( 'Button', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Get Started' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'link_button',
						'label'       => esc_html__( 'Link Button', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'https://shtheme.com/demosd/ziptech/?page_id=135' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Subtitle', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		?> 
<section class="saas-feature-block1 pdt-110 pdt-sm-0 pdb-90 bg-no-repeat bg-cover bg-pos-cc" data-overlay-light="7" data-background="<?php print esc_url($settings['bg_image']['url']); ?>">
  <div class="container">
	<?php
    	$idd = 0;
    	foreach ( $settings['tabs'] as $item ) :
    	$idd++;
	?>
	<?php if($idd%2 == 1) { ?>
    <div class="row mrb-150 mrb-sm-110 align-items-center">
      <div class="col-xl-6 col-lg-6">
        <div class="banner-info">
        	<?php if (( '' !== $item['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
          <h5 class="side-line-left sub-title text-gradient-color"><?php echo wp_kses_post($item['subtitle']); ?></h5>
          <?php endif; ?>
          <?php if (( '' !== $item['title'] ) && ( $settings['show_title'] )) : ?>
          <h2 class="banner-title mrb-30"><?php echo wp_kses_post($item['title']); ?></h2>
          <?php endif; ?>
          <?php if (( '' !== $item['desc'] ) && ( $settings['show_desc'] )) : ?>
          <p class="banner-text mrb-40"><?php echo wp_kses_post($item['desc']); ?></p>
          <?php endif; ?>
          <?php if (( '' !== $item['button'] ) && ( $settings['show_button'] )) : ?>
          <div class="button mrb-md-60">
            <a class="theme-btn-1" href="<?php echo wp_kses_post($item['link_button']); ?>"><?php echo wp_kses_post($item['button']); ?></a>
          </div>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-xl-6 col-lg-6">
        <div class="banner-thumb">
          <img src="<?php print esc_url($item['image']['url']); ?>" alt="Thumb" />
        </div>
      </div>
    </div>
	<?php } else { ?>
    <div class="row align-items-center">
      <div class="col-xl-6 col-lg-6">
        <div class="banner-thumb mrb-md-40">
          <img src="<?php print esc_url($item['image']['url']); ?>" alt="Thumb" />
        </div>
      </div>
      <div class="col-xl-6 col-lg-6">
        <div class="banner-info mrl-50 mrl-md-0">
          <?php if (( '' !== $item['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
          <h5 class="side-line-left sub-title text-gradient-color"><?php echo wp_kses_post($item['subtitle']); ?></h5>
          <?php endif; ?>
          <?php if (( '' !== $item['title'] ) && ( $settings['show_title'] )) : ?>
          <h2 class="banner-title mrb-30"><?php echo wp_kses_post($item['title']); ?></h2>
          <?php endif; ?>
          <?php if (( '' !== $item['desc'] ) && ( $settings['show_desc'] )) : ?>
          <p class="banner-text mrb-40"><?php echo wp_kses_post($item['desc']); ?></p>
          <?php endif; ?>
          <?php if (( '' !== $item['button'] ) && ( $settings['show_button'] )) : ?>
          <div class="button mrb-md-60">
            <a class="theme-btn-1" href="<?php echo wp_kses_post($item['link_button']); ?>"><?php echo wp_kses_post($item['button']); ?></a>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
	<?php }  ?>
    <?php endforeach; ?>
  </div>
</section>
	<?php
	}

}
