<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsBlog extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-blog';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Blog Main Layout', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'main-layout' ];
	}

	public function get_keywords() {
		return [ 'blog-post' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content_service_post',
			[
				'label' => esc_html__( 'Blog Post', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label'       => esc_html__( 'Background Image', 'bdevs-elementor' ),
				'type'        => Controls_Manager::MEDIA,
				'dynamic'     => [ 'active' => true ],
				'label_block' => true,
				'description' => esc_html__( 'Upload Background Image', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'Latest Blog', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'News & Updates', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'title_big_text',
			[
				'label'       => __( 'Title Big Text', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title Big Text', 'bdevs-elementor' ),
				'default'     => __( 'News', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'bdevs-elementor' ),
				'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing nesciunt, aliquam alias sunt. Dolores aliquid unde reprehenderit omnis vitae cupiditate distinctio?', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'link_button',
			[
				'label'       => __( 'Link Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Link Button', 'bdevs-elementor' ),
				'default'     => __( 'https://shtheme.com/demosd/ziptech/?page_id=171', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'button',
			[
				'label'       => __( ' Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your  Button', 'bdevs-elementor' ),
				'default'     => __( 'All News', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderpost',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'date'  => esc_html__( 'Date', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'rand' => esc_html__( 'Random', 'bdevs-elementor' ),
				],
				'default'   => 'desc',

			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_call_to_action',
			[
				'label' => esc_html__( 'Call To Action', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'icon',
			[
				'label'       => __( 'Icon Call To Action', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Icon', 'bdevs-elementor' ),
				'default'     => __( 'webexflaticon base-icon-chat1', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Subtitle', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subtitle', 'bdevs-elementor' ),
				'default'     => __( 'Need Any Consultaitons?', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title', 'bdevs-elementor' ),
				'default'     => __( 'We are ready to help you', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'link_button2',
			[
				'label'       => __( 'Link Button Call To Action', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title Big Text', 'bdevs-elementor' ),
				'default'     => __( 'https://shtheme.com/demosd/ziptech/?page_id=154', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'button2',
			[
				'label'       => __( ' Button Call To Action', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your  Button', 'bdevs-elementor' ),
				'default'     => __( 'Contact Us', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'show_title_big_text',
			[
				'label'   => esc_html__( 'Show Title Big Text', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_icon',
			[
				'label'   => esc_html__( 'Show Icon Call to Actions', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title Call to Actions', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Subtitle Call to Actions', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'show_button2',
			[
				'label'   => esc_html__( 'Show Button Call to Actions', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	


		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		extract($settings); ?>
<section class="pdt-105 bg-cover" data-background="<?php print esc_url($settings['bg_image']['url']); ?>">
      <div class="section-title mrb-60 wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
        <div class="container">
          <div class="row align-items-end">
            <div class="col-xl-6 col-lg-8 col-md-12">
              <div class="title-box-center">
                <?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                <h5 class="side-line-left sub-title text-gradient-color"><?php echo wp_kses_post($settings['subheading']); ?></h5>
                <?php endif; ?>
                <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                <h2 class="mrb-25"><?php echo wp_kses_post($settings['heading']); ?></h2>
                <?php endif; ?>
                <?php if (( '' !== $settings['title_big_text'] ) && ( $settings['show_title_big_text'] )) : ?>
                <div class="section-title-big_text"><?php echo wp_kses_post($settings['title_big_text']); ?></div>
                <?php endif; ?>
                <?php if (( '' !== $settings['desc'] ) && ( $settings['show_desc'] )) : ?>
                <p class="mrb-0 mrb-md-40"><?php echo wp_kses_post($settings['desc']); ?></p>
                <?php endif; ?>
              </div>
            </div>
            <?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )) : ?>
            <div class="col-xl-6 col-lg-4 col-md-12 text-lg-end">
              <a href="<?php echo wp_kses_post($settings['link_button']); ?>" class="theme-btn-1"><?php echo wp_kses_post($settings['button']); ?> <i class="base-icon-next"></i></a>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <div class="section-content mrb-80">
        <div class="container">
          <div class="row justify-content-center">
          	<?php 
            $q = new \WP_Query(array(
                'post_type'     => 'post',
                'posts_per_page'=> $number,
                'orderby'       => $orderby,
                'order'         => $orderpost,
            ));
        	while($q->have_posts()): $q->the_post();  
        		$cates = get_the_terms(get_the_ID(),'category');
		            $cate_name = '';
		            $cate_slug = '';
		        foreach((array)$cates as $cate){
		            if(count($cates)>0){
		                $cate_name .= $cate->name.' ';
		                $cate_slug .= $cate->slug.' ';
		            }
		        }
        	?>
            <div class="col-md-6 col-lg-6 col-xl-4">
              <div class="news-wrapper-style1 mrb-30">
                <div class="news-thumb">
                  <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" class="img-full" alt="blog" />
                  <div class="news-top-meta">
                    <span class="entry-category"><?php echo esc_attr($cate_name);?></span>
                  </div>
                </div>
                <div class="news-description">
                  <h4 class="the-title">
                    <a href="<?php the_permalink();?>"><?php the_title(); ?></a>
                  </h4>
                  <div class="news-bottom-part">
                    <div class="post-author">
                      <div class="author-img">
                        <a>
                          <img src="<?php echo get_template_directory_uri();?>/images/testimonials/testimonial-img1.jpg" class="rounded-circle" alt="#" />
                        </a>
                      </div>
                      <span><?php the_author_posts_link();?></span>
                    </div>
                    <div class="post-link">
                      <span class="entry-date"><i class="far fa-calendar-alt mrr-10 text-gradient-color"></i><?php the_time(get_option( 'date_format' ));?></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <?php endwhile; ?>
          </div>
        </div>
      </div>
	<div class="call-to-action">
        <div class="container">
          <div class="call-to-action-inner">
            <div class="call-to-action-left">
            	<?php if (( '' !== $settings['icon'] ) && ( $settings['show_icon'] )) : ?>
              <div class="call-to-action-icon">
                <span class="<?php echo wp_kses_post($settings['icon']); ?>"></span>
              </div>
              <?php endif; ?>
              <div class="call-to-action-content">
              	<?php if (( '' !== $settings['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
                <p class="call-to-action-sub-title"><?php echo wp_kses_post($settings['subtitle']); ?></p>
                <?php endif; ?>
                <?php if (( '' !== $settings['title'] ) && ( $settings['show_title'] )) : ?>
                <h2 class="call-to-action-title"><?php echo wp_kses_post($settings['title']); ?></h2>
                <?php endif; ?>
              </div>
            </div>
            <?php if (( '' !== $settings['button2'] ) && ( $settings['show_button2'] )) : ?>
            <div class="call-to-action-btn-box mrt-15 mrt-md-30">
              <a href="<?php echo wp_kses_post($settings['link_button2']); ?>" class="theme-btn-2"><?php echo wp_kses_post($settings['button2']); ?></a>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <!-- Call to Action End -->
    </section>
	<?php
	}
}