<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsTestimonialIT extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-testimonial-it-solution';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Testimonial It Solutions', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'it-solutions' ];
	}

	public function get_keywords() {
		return [ 'testimonial' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_testimonial',
			[
				'label' => esc_html__( 'Testimonial', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'select',
			[
				'label'       => __( 'Choose Select', 'bdevs-elementor' ),
				'type'        => Controls_Manager::SELECT,
				'dynamic'     => [ 'active' => true ],
				'options'   => [
									'rtl'  => esc_html__( 'RTL', 'bdevs-elementor' ),
									'ltr' => esc_html__( 'LTR', 'bdevs-elementor' ),
								],
				'default'   => 'ltr',
				'label_block' => true,
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label'       => __( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],			
			]
		);
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Testimonial Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'    => 'avatar',
						'label'   => esc_html__( 'Avatar Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
					],
					[
						'name'        => 'desc',
						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit oluptatibus blanditiis amet optio fugiat nisi est repellendus iusto quis harum laboriosam nostrum unde distinctio ' , 'bdevs-elementor' ),
						'label_block' => true,
					],		
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Jesica Nowmi' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Client, USA' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'star',
						'label'       => esc_html__( 'Star', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					
				],
			]
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'Our Testimonials', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'What Our Client is Say?', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'text1',
			[
				'label'       => __( 'Text 1', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Text 1', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'text2',
			[
				'label'       => __( 'Text 2', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Text 2', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_text1',
			[
				'label'   => esc_html__( 'Show Text 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_text2',
			[
				'label'   => esc_html__( 'Show Text 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Subtitle', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_star',
			[
				'label'   => esc_html__( 'Show Star', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_avatar',
			[
				'label'   => esc_html__( 'Show Avatar', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
	?> 
<?php if($settings['select']=='rtl') { ?>
<section class="testimonial-style2-section pos-rel bg-no-repeat bg-cover bg-pos-cb pdt-110 pdb-180 pdb-lg-70" data-background="<?php print esc_url($settings['bg_image']['url']); ?>" data-overlay-gradient-color1="9">
      <div class="shape-obj1"></div>
      <div class="shape-obj2"></div>
      <div class="section-content">
        <div class="container">
          <div class="row">
            <div class="col-xl-6 col-lg-8 col-md-12">
              <div class="testimonial-style2-wrapper">
                <div class="owl-carousel testmonial_1col_rtl">
                	<?php
				    	$idd = 0;
				    	foreach ( $settings['tabs'] as $item ) :
				    	$idd++;
					?>
                  <div class="testimonial-style2">
                    <div class="testimonial-item">
                      <div class="testimonial-image-block">
                      	<?php if (( '' !== $item['avatar'] ) && ( $settings['show_avatar'] )) : ?>
                        <div class="testimonial-image">
                          <img src="<?php print esc_url($item['avatar']['url']); ?>" alt="" />
                        </div>
                        <?php endif; ?>
                        <div class="testimonial-quote-icon">
                          <i class="base-icon-left-quote1"></i>
                        </div>
                      </div>
                      <div class="testimonial-content-block">
                      	<?php if (( '' !== $item['desc'] ) && ( $settings['show_desc'] )) : ?>
                        <p class="testimonial-text"><?php echo wp_kses_post($item['desc']); ?></p>
                        <?php endif; ?>
                        <div class="testimonial-details">
                          <div class="testimonial-client-info">
                          	<?php if (( '' !== $item['title'] ) && ( $settings['show_title'] )) : ?>
                            <h5 class="testimonial-title"><?php echo wp_kses_post($item['title']); ?></h5>
                            <?php endif; ?>
                            <?php if (( '' !== $item['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
                            <p class="testimonial-designation"><?php echo wp_kses_post($item['subtitle']); ?></p>
                            <?php endif; ?>
                          </div>
                          <?php if (( '' !== $item['star'] ) && ( $settings['show_star'] )) : ?>
                          <div class="testimonial-rating">
                            <ul>
                              <?php echo wp_kses_post($item['star']); ?>
                            </ul>
                          </div>
                          	<?php endif; ?>
                        </div>
                      </div>
                    </div>
                  </div>
                  <?php endforeach; ?>
                </div>
              </div>
            </div>
            <div class="col-xl-6 col-lg-10 col-md-12">
              <div class="mrl-40 mrl-lg-0 mrt-lg-135 mrt-md-60">
                <div class="title-box">
                	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                  <h5 class="side-line-left sub-title white text-white"><?php echo wp_kses_post($settings['subheading']); ?></h5>
                  <?php endif; ?>
                  <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                  <h2 class="text-white mrb-35"><?php echo wp_kses_post($settings['heading']); ?></h2>
                  <?php endif; ?>
                </div>
                <div class="row">
                	<?php if (( '' !== $settings['text1'] ) && ( $settings['show_text1'] )) : ?>
                  <div class="col-md-6 col-lg-6 col-xl-6">
                    <ul class="order-list text-fill-white mrb-35 mrb-sm-15">
                      <?php echo wp_kses_post($settings['text1']); ?>
                    </ul>
                  </div>
                  <?php endif; ?>
                  <?php if (( '' !== $settings['text2'] ) && ( $settings['show_text2'] )) : ?>
                  <div class="col-md-6 col-lg-6 col-xl-6">
                    <ul class="order-list text-fill-white mrb-35">
                      <?php echo wp_kses_post($settings['text2']); ?>
                    </ul>
                  </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php if (is_admin()) { ?>
<script type="text/javascript">
	var owl = $(".testmonial_1col_rtl");
    owl.owlCarousel({
      loop: true,
      margin: 30,
      autoplay: true,
      autoplayTimeout: 8000,
      nav: true,
      dots: false,
      rtl: true,
      navText: ["<i class='base-icon-right-chevron'></i>", "<i class='base-icon-left-chevron'></i>"],
      responsive: {
        0: {
          items: 1
        },
        425: {
          items: 1
        },
        768: {
          items: 1
        },
        1024: {
          items: 1
        },
        1440: {
          items: 1
        }
      }
    });
</script>
<?php }  ?>
<?php } else { ?>
<section class="testimonial-style2-section pos-rel bg-no-repeat bg-cover bg-pos-cb pdt-110 pdb-180 pdb-lg-70" data-background="<?php print esc_url($settings['bg_image']['url']); ?>" data-overlay-gradient-color1="9">
      <div class="shape-obj1"></div>
      <div class="shape-obj2"></div>
      <div class="section-content">
        <div class="container">
          <div class="row">
            <div class="col-xl-6 col-lg-8 col-md-12">
              <div class="testimonial-style2-wrapper">
                <div class="owl-carousel testmonial_1col">
                	<?php
				    	$idd = 0;
				    	foreach ( $settings['tabs'] as $item ) :
				    	$idd++;
					?>
                  <div class="testimonial-style2">
                    <div class="testimonial-item">
                      <div class="testimonial-image-block">
                      	<?php if (( '' !== $item['avatar'] ) && ( $settings['show_avatar'] )) : ?>
                        <div class="testimonial-image">
                          <img src="<?php print esc_url($item['avatar']['url']); ?>" alt="" />
                        </div>
                        <?php endif; ?>
                        <div class="testimonial-quote-icon">
                          <i class="base-icon-left-quote1"></i>
                        </div>
                      </div>
                      <div class="testimonial-content-block">
                      	<?php if (( '' !== $item['desc'] ) && ( $settings['show_desc'] )) : ?>
                        <p class="testimonial-text"><?php echo wp_kses_post($item['desc']); ?></p>
                        <?php endif; ?>
                        <div class="testimonial-details">
                          <div class="testimonial-client-info">
                          	<?php if (( '' !== $item['title'] ) && ( $settings['show_title'] )) : ?>
                            <h5 class="testimonial-title"><?php echo wp_kses_post($item['title']); ?></h5>
                            <?php endif; ?>
                            <?php if (( '' !== $item['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
                            <p class="testimonial-designation"><?php echo wp_kses_post($item['subtitle']); ?></p>
                            <?php endif; ?>
                          </div>
                          <?php if (( '' !== $item['star'] ) && ( $settings['show_star'] )) : ?>
                          <div class="testimonial-rating">
                            <ul>
                              <?php echo wp_kses_post($item['star']); ?>
                            </ul>
                          </div>
                          	<?php endif; ?>
                        </div>
                      </div>
                    </div>
                  </div>
                  <?php endforeach; ?>
                </div>
              </div>
            </div>
            <div class="col-xl-6 col-lg-10 col-md-12">
              <div class="mrl-40 mrl-lg-0 mrt-lg-135 mrt-md-60">
                <div class="title-box">
                	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                  <h5 class="side-line-left sub-title white text-white"><?php echo wp_kses_post($settings['subheading']); ?></h5>
                  <?php endif; ?>
                  <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                  <h2 class="text-white mrb-35"><?php echo wp_kses_post($settings['heading']); ?></h2>
                  <?php endif; ?>
                </div>
                <div class="row">
                	<?php if (( '' !== $settings['text1'] ) && ( $settings['show_text1'] )) : ?>
                  <div class="col-md-6 col-lg-6 col-xl-6">
                    <ul class="order-list text-fill-white mrb-35 mrb-sm-15">
                      <?php echo wp_kses_post($settings['text1']); ?>
                    </ul>
                  </div>
                  <?php endif; ?>
                  <?php if (( '' !== $settings['text2'] ) && ( $settings['show_text2'] )) : ?>
                  <div class="col-md-6 col-lg-6 col-xl-6">
                    <ul class="order-list text-fill-white mrb-35">
                      <?php echo wp_kses_post($settings['text2']); ?>
                    </ul>
                  </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php if (is_admin()) { ?>
<script type="text/javascript">
	var owl = $(".testmonial_1col");
    owl.owlCarousel({
      loop: true,
      margin: 30,
      autoplay: true,
      autoplayTimeout: 8000,
      nav: true,
      dots: false,
      navText: ["<i class='base-icon-left-chevron'></i>", "<i class='base-icon-right-chevron'></i>"],
      responsive: {
        0: {
          items: 1
        },
        425: {
          items: 1
        },
        768: {
          items: 1
        },
        1024: {
          items: 1
        },
        1440: {
          items: 1
        }
      }
    });
</script>
<?php }  ?>
<?php }  ?>
	<?php
	}

}