<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsProjectDA extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-projects-degital-agency';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Project Digital Agency', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Project widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Project widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'degital-agency' ];
	}

	public function get_keywords() {
		return [ 'Project', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_Projects',
			[
				'label' => esc_html__( 'Projects', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'select',
			[
				'label'       => __( 'Choose Select', 'bdevs-elementor' ),
				'type'        => Controls_Manager::SELECT,
				'dynamic'     => [ 'active' => true ],
				'options'   => [
									'rtl'  => esc_html__( 'RTL', 'bdevs-elementor' ),
									'ltr' => esc_html__( 'LTR', 'bdevs-elementor' ),
								],
				'default'   => 'ltr',
				'label_block' => true,
			]
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subheading', 'bdevs-elementor' ),
				'default'     => __( 'Our Projects', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'We Offer Exclusive IT Projects', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'title_big_text',
			[
				'label'       => __( 'Title Big Text', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title Big Text', 'bdevs-elementor' ),
				'default'     => __( 'Projects', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'bdevs-elementor' ),
				'default'     => __( 'Lorem ipsum dolor sit amet consectetur adipiscing augue curae duis pellentesque proin, quam faucibus accumsan feugiat donec aliquet', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '6',
			]
		);
		$this->add_control(
			'orderpost',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'date'  => esc_html__( 'Date', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'rand' => esc_html__( 'Random', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title_big_text',
			[
				'label'   => esc_html__( 'Show Title Big Text', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$wp_query = new \WP_Query(array('post_type' => 'projects','paged' => $paged, 'posts_per_page' => $settings['post_number'],'orderby' => $settings['orderby'], 'order' => $settings['orderpost'],));
		$ziptech_redux_demo = get_option('redux_demo');
		extract($settings);
		?> 
<section class="pdt-105">
      <div class="section-title mrb-55 mrb-lg-60 wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
        <div class="container">
          <div class="row align-items-end">
            <div class="col-xl-8 col-lg-12 col-md-12">
              <div class="title-box">
              	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                <h5 class="side-line-left sub-title text-gradient-color"><?php echo wp_kses_post($settings['subheading']); ?></h5>
                <?php endif; ?>
                <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                <h2 class="mrb-0 mrb-lg-35">
                  <?php echo wp_kses_post($settings['heading']); ?>
                </h2>
                <?php endif; ?>
                <?php if (( '' !== $settings['title_big_text'] ) && ( $settings['show_title_big_text'] )) : ?>
                <div class="section-title-big_text"><?php echo wp_kses_post($settings['title_big_text']); ?></div>
                <?php endif; ?>
              </div>
            </div>
            <?php if (( '' !== $settings['desc'] ) && ( $settings['show_desc'] )) : ?>
            <div class="col-xl-4 col-lg-8 col-md-12 text-lg-start text-xs-end">
              <p class="mrb-0"><?php echo wp_kses_post($settings['desc']); ?></p>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <div class="section-content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-xl-12">
              <div class="project-item-style1-wrapper">
              	<?php if($settings['select']=='rtl') { ?>
                <div class="owl-carousel projects_5col_rtl">
                <?php } else { ?>
                <div class="owl-carousel projects_5col">
                <?php }  ?>
                	<?php
	                while($wp_query->have_posts()): $wp_query->the_post();
	                $cates = get_the_terms(get_the_ID(),'Type2');
	                    $cate_name = '';
	                    $cate_slug = '';
	                foreach((array)$cates as $cate){
	                    if(count($cates)>0){
	                        $cate_name .= $cate->name.' ';
	                        $cate_slug .= $cate->slug.' ';
	                    }
	                }
	                ?>
	                <?php $image_home = get_post_meta(get_the_ID(),'_cmb_image_home', true); ?>
	                <?php $icon = get_post_meta(get_the_ID(),'_cmb_icon', true); ?>
                  <div class="project-item-style1">
                    <span class="<?php echo esc_attr($icon);?>"></span>
                    <div class="project-item-thumb">
                      <a class="project-item-link-image" href="<?php the_permalink();?>">
                        <img class="img-full" src="<?php echo wp_get_attachment_url($image_home);?>" alt="" />
                      </a>
                    </div>
                    <div class="project-item-details">
                      <div class="project-item-details-inner">
                        <h6 class="project-item-category"><a href="<?php the_permalink();?>"><?php echo esc_attr($cate_name);?></a></h6>
                        <h4 class="title"><?php the_title(); ?></h4>
                        <div class="project-item-link-icon">
                          <a href="<?php the_permalink();?>"><i class="base-icon-next"></i></a>
                        </div>
                      </div>
                    </div>
                    <div class="project-item-details-hover">
                      <div class="project-item-details-inner">
                        <h4 class="title"><?php the_title(); ?></h4>
                        <div class="desc"><?php if(isset($ziptech_redux_demo['projects_excerpt'])){?>
                            <?php echo esc_attr(ziptech_excerpt4($ziptech_redux_demo['projects_excerpt'])); ?>
                            <?php }else{?>
                            <?php echo esc_attr(ziptech_excerpt4(10)); } ?></div>
                        <div class="project-item-link-icon">
                          <a href="<?php the_permalink();?>"><i class="base-icon-next"></i></a>
                        </div>
                      </div>
                    </div>
                    <a class="bg-overlay" href="<?php the_permalink();?>"></a>
                  </div>
                  
                  <?php endwhile; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
<?php if (is_admin())
  { ?>
<script type="text/javascript">
	var owl = $(".projects_5col");
    owl.owlCarousel({
      loop: true,
      margin: 10,
      autoplay: true,
      autoplayTimeout: 8000,
      nav: true,
      dots: false,
      navText: ["<i class='base-icon-left-chevron'></i>", "<i class='base-icon-right-chevron'></i>"],
      responsive: {
        0: {
          items: 1
        },
        425: {
          items: 1
        },
        768: {
          items: 2
        },
        1024: {
          items: 3
        },
        1440: {
          items: 5
        }
      }
    });
</script>
<?php }  ?>
	<?php
	}

}
